/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.ConversionGroup;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.Book;
import uk.yermak.audiobookconverter.book.Convertable;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.Organisable;
import uk.yermak.audiobookconverter.fx.BookStructureComponent;
import uk.yermak.audiobookconverter.fx.ConversionContext;
import uk.yermak.audiobookconverter.fx.ConversionProgress;
import uk.yermak.audiobookconverter.fx.DialogHelper;
import uk.yermak.audiobookconverter.fx.FileListComponent;
import uk.yermak.audiobookconverter.fx.ProgressComponent;
import uk.yermak.audiobookconverter.fx.SettingsDialog;
import uk.yermak.audiobookconverter.loaders.FFMediaLoader;

public class FilesController {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public MenuItem removeMenu;
    @FXML
    private Button addButton;
    @FXML
    private Button clearButton;
    @FXML
    private Button importButton;
    @FXML
    private TabPane filesChapters;
    @FXML
    private Tab chaptersTab;
    @FXML
    private Tab filesTab;
    @FXML
    private Tab queueTab;
    @FXML
    private ListView<ProgressComponent> progressQueue;
    @FXML
    private TabPane tabs;
    @FXML
    private Button pauseButton;
    @FXML
    private Button stopButton;
    @FXML
    private FileListComponent fileList;
    @FXML
    BookStructureComponent bookStructure;
    @FXML
    private Button startButton;
    private final ContextMenu contextMenu = new ContextMenu();
    private final BooleanProperty chaptersMode = new SimpleBooleanProperty(false);
    @FXML
    private TreeTableColumn<Organisable, String> chapterColumn;
    @FXML
    private TreeTableColumn<Organisable, String> durationColumn;
    @FXML
    private TreeTableColumn<Organisable, String> detailsColumn;

    @FXML
    public void initialize() {
        this.addDragEvenHandlers(this.bookStructure);
        this.addDragEvenHandlers(this.fileList);
        this.addDragEvenHandlers(this.progressQueue);
        Settings settings = Settings.loadSetting();
        AudiobookConverter.getContext().setPresetName(settings.getPresets().get(settings.getLastUsedPreset()).getName());
        this.initFileOpenMenu();
        ConversionContext context = AudiobookConverter.getContext();
        ObservableList<MediaInfo> selectedMedia = context.getSelectedMedia();
        selectedMedia.addListener(observable -> {
            if (selectedMedia.isEmpty() || this.chaptersMode.get()) {
                return;
            }
            this.fileList.reselect();
        });
        this.filesChapters.getTabs().remove((Object)this.filesTab);
        this.filesChapters.getTabs().remove((Object)this.chaptersTab);
        this.bookStructure.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.bookStructure.getSelectionModel().getSelectedItems().addListener(c -> {
            ObservableList<MediaInfo> list = AudiobookConverter.getContext().getSelectedMedia();
            list.clear();
            List newList = c.getList().stream().flatMap(item -> ((Organisable)item.getValue()).getMedia().stream()).collect(Collectors.toList());
            list.addAll(newList);
        });
        this.chapterColumn.setCellValueFactory((Callback<TreeTableColumn.CellDataFeatures<Organisable, String>, ObservableValue<String>>)((Callback)p -> new ReadOnlyObjectWrapper((Object)((Organisable)p.getValue().getValue()).getTitle())));
        this.detailsColumn.setCellValueFactory((Callback<TreeTableColumn.CellDataFeatures<Organisable, String>, ObservableValue<String>>)((Callback)p -> new ReadOnlyObjectWrapper((Object)((Organisable)p.getValue().getValue()).getDetails())));
        this.durationColumn.setCellValueFactory((Callback<TreeTableColumn.CellDataFeatures<Organisable, String>, ObservableValue<String>>)((Callback)p -> new ReadOnlyObjectWrapper((Object)Utils.formatTime(((Organisable)p.getValue().getValue()).getDuration()))));
        this.importButton.setDisable(true);
        this.chaptersMode.addListener((observableValue, oldValue, newValue) -> this.importButton.setDisable(newValue != false || this.fileList.getItems().isEmpty()));
        this.fileList.getItems().addListener(change -> this.importButton.setDisable(this.fileList.getItems().isEmpty()));
        context.addSpeedChangeListener((observableValue, oldValue, newValue) -> {
            if (this.chaptersMode.get()) {
                Platform.runLater(() -> this.bookStructure.updateBookStructure());
            }
        });
    }

    private void initFileOpenMenu() {
        MenuItem item1 = new MenuItem("Files");
        item1.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.selectFiles()));
        MenuItem item2 = new MenuItem("Folder");
        item2.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.selectFolder()));
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{item1, item2});
    }

    private void addDragEvenHandlers(Control control) {
        control.setOnDragOver(event -> {
            if (event.getGestureSource() != control && event.getDragboard().hasFiles()) {
                event.acceptTransferModes(TransferMode.ANY);
            }
            event.consume();
        });
        control.setOnDragDropped(event -> {
            List files = event.getDragboard().getFiles();
            if (files != null && !files.isEmpty()) {
                List<String> fileNames = DialogHelper.collectFiles(files);
                this.processFiles(fileNames);
                event.setDropCompleted(true);
                event.consume();
                if (!this.chaptersMode.get() && !this.filesChapters.getTabs().contains((Object)this.filesTab)) {
                    this.filesChapters.getTabs().add((Object)this.filesTab);
                    this.filesChapters.getSelectionModel().select(this.filesTab);
                }
            }
        });
    }

    @FXML
    protected void addFiles(ActionEvent event) {
        Button node = (Button)event.getSource();
        this.contextMenu.show((Node)node, Side.RIGHT, 0.0, 0.0);
    }

    public void selectFolder() {
        List<String> fileNames = DialogHelper.selectFolderDialog();
        if (fileNames != null) {
            this.processFiles(fileNames);
            if (!this.chaptersMode.get()) {
                if (!this.filesChapters.getTabs().contains((Object)this.filesTab)) {
                    this.filesChapters.getTabs().add((Object)this.filesTab);
                }
                this.filesChapters.getSelectionModel().select(this.filesTab);
            }
        }
    }

    private void processFiles(List<String> fileNames) {
        FFMediaLoader mediaLoader = this.createMediaLoader(fileNames);
        AudiobookConverter.getContext().setMediaLoader(mediaLoader);
        List<MediaInfo> addedMedia = mediaLoader.loadMediaInfo();
        if (this.chaptersMode.get()) {
            AudiobookConverter.getContext().constructBook(addedMedia);
            this.bookStructure.updateBookStructure();
        } else {
            AudiobookConverter.getContext().addNewMedia(addedMedia);
        }
    }

    private FFMediaLoader createMediaLoader(List<String> fileNames) {
        return new FFMediaLoader(fileNames, AudiobookConverter.getContext().getConversionGroup());
    }

    public void selectFiles() {
        List<String> fileNames = DialogHelper.selectFilesDialog();
        if (fileNames != null) {
            this.processFiles(fileNames);
            if (!this.chaptersMode.get()) {
                if (!this.filesChapters.getTabs().contains((Object)this.filesTab)) {
                    this.filesChapters.getTabs().add((Object)this.filesTab);
                }
                this.filesChapters.getSelectionModel().select(this.filesTab);
            }
        }
    }

    @FXML
    public void remove(ActionEvent event) {
        if (this.chaptersMode.get()) {
            this.bookStructure.removeChapters(event);
        } else {
            this.fileList.removeFiles(event);
        }
    }

    public void clear(ActionEvent event) {
        this.fileList.getItems().clear();
        AudiobookConverter.getContext().getConversionGroup().cancel();
        AudiobookConverter.getContext().detach();
        this.bookStructure.setRoot(null);
        this.filesChapters.getTabs().remove((Object)this.filesTab);
        this.filesChapters.getTabs().remove((Object)this.chaptersTab);
        this.chaptersMode.set(false);
    }

    public void moveUp(ActionEvent event) {
        if (this.chaptersMode.get()) {
            this.bookStructure.moveChapterUp(event);
        } else {
            this.fileList.moveFileUp(event);
        }
    }

    public void moveDown(ActionEvent event) {
        if (this.chaptersMode.get()) {
            this.bookStructure.moveChapterDown(event);
        } else {
            this.fileList.moveFileDown(event);
        }
    }

    public void subTracks(ActionEvent event) {
        if (this.chaptersMode.get()) {
            this.bookStructure.subTracks(event);
        }
    }

    public void editChapter(ActionEvent event) {
        if (this.chaptersMode.get()) {
            this.bookStructure.editChapter(event);
        }
    }

    public void start(ActionEvent actionEvent) {
        ConversionContext context = AudiobookConverter.getContext();
        if (context.getBook() == null && this.fileList.getItems().isEmpty()) {
            return;
        }
        String outputDestination = DialogHelper.selectOutputFile(AudiobookConverter.getContext().getBookInfo());
        if (outputDestination == null) {
            return;
        }
        ConversionGroup conversionGroup = AudiobookConverter.getContext().detach();
        ProgressComponent placeHolderProgress = new ProgressComponent(new ConversionProgress(new ConversionJob(conversionGroup, Convertable.EMPTY, Collections.emptyMap(), outputDestination)));
        Executors.newSingleThreadExecutor().submit(() -> {
            Platform.runLater(() -> {
                this.progressQueue.getItems().add(0, (Object)placeHolderProgress);
                this.filesChapters.getSelectionModel().select(this.queueTab);
            });
            conversionGroup.launch(this.progressQueue, placeHolderProgress, outputDestination);
        });
        this.bookStructure.setRoot(null);
        this.filesChapters.getTabs().remove((Object)this.filesTab);
        this.filesChapters.getTabs().remove((Object)this.chaptersTab);
        context.getMedia().clear();
        context.getPosters().clear();
        this.chaptersMode.set(false);
    }

    public void importChapters(ActionEvent actionEvent) {
        if (this.fileList.getItems().isEmpty()) {
            return;
        }
        this.startButton.setDisable(true);
        this.filesChapters.getTabs().add((Object)this.chaptersTab);
        this.filesChapters.getTabs().remove((Object)this.filesTab);
        this.bookStructure.setShowRoot(false);
        ObservableList mediaInfos = FXCollections.observableArrayList(this.fileList.getItems());
        Book book = new Book(AudiobookConverter.getContext().getBookInfo());
        TreeItem<Book> bookItem = new TreeItem<Book>(book);
        this.bookStructure.setRoot(bookItem);
        AudiobookConverter.getContext().setBook(book);
        this.bookStructure.updateBookStructure();
        bookItem.setExpanded(true);
        this.filesChapters.getSelectionModel().select(this.chaptersTab);
        this.fileList.getItems().clear();
        this.chaptersMode.set(true);
        long lastBookUpdate = System.currentTimeMillis();
        book.addListener(observable -> {
            logger.debug("Captured book modification");
            if (System.currentTimeMillis() - lastBookUpdate > 1000L) {
                Platform.runLater(() -> this.bookStructure.updateBookStructure());
            }
        });
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                book.construct((List<MediaInfo>)mediaInfos);
                this.bookStructure.updateBookStructure();
            }
            finally {
                this.startButton.setDisable(false);
            }
        });
    }

    @FXML
    public void combine(ActionEvent event) {
        this.bookStructure.combineChapters(event);
    }

    @FXML
    public void split(ActionEvent event) {
        this.bookStructure.split(event);
    }

    @FXML
    public void pause(ActionEvent actionEvent) {
        ConversionContext context = AudiobookConverter.getContext();
        if (context.isPaused()) {
            context.resumeConversions();
            this.pauseButton.setText("Pause all");
        } else {
            context.pauseConversions();
            this.pauseButton.setText("Resume all");
        }
    }

    public void stop(ActionEvent actionEvent) {
        AudiobookConverter.getContext().stopConversions();
    }

    @FXML
    protected void openLink(ActionEvent event) {
        Hyperlink source = (Hyperlink)event.getSource();
        AudiobookConverter.getEnv().showDocument(source.getUserData().toString());
    }

    public void openWebSite(ActionEvent actionEvent) {
        AudiobookConverter.getEnv().showDocument("https://www.recoupler.com/products/audiobookconverter");
    }

    public void openAboutPage(ActionEvent actionEvent) {
        AudiobookConverter.getEnv().showDocument("https://www.recoupler.com/products/audiobookconverter/about");
    }

    public void openFAQ(ActionEvent actionEvent) {
        AudiobookConverter.getEnv().showDocument("https://www.recoupler.com/products/audiobookconverter/faq");
    }

    public void openDiscussions(ActionEvent actionEvent) {
        AudiobookConverter.getEnv().showDocument("https://github.com/yermak/AudioBookConverter/discussions");
    }

    public void openDonate() {
        AudiobookConverter.getEnv().showDocument("https://www.recoupler.com/products/audiobookconverter/donate");
    }

    public void checkVersion(ActionEvent actionEvent) {
        AudiobookConverter.checkNewVersion();
    }

    public void exit(ActionEvent actionEvent) {
        logger.info("Closing application");
        AudiobookConverter.getContext().stopConversions();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void clearQueue(ActionEvent actionEvent) {
        ObservableList<ProgressComponent> items = this.progressQueue.getItems();
        ArrayList<ProgressComponent> dones = new ArrayList<ProgressComponent>();
        for (ProgressComponent item : items) {
            if (!item.isOver()) continue;
            dones.add(item);
        }
        Platform.runLater(() -> {
            for (ProgressComponent done : dones) {
                this.progressQueue.getItems().remove((Object)done);
            }
        });
    }

    public void settings(ActionEvent actionEvent) {
        SettingsDialog dialog = new SettingsDialog(AudiobookConverter.getEnv().getWindow());
        Optional result = dialog.showAndWait();
        result.ifPresent(r -> {
            Boolean darkMode = (Boolean)r.get("dark_mode");
            String filenameFormat = (String)r.get("filename_format");
            String partFormat = (String)r.get("part_format");
            String chapterFormat = (String)r.get("chapter_format");
            Boolean showHints = (Boolean)r.get("show_hints");
            Settings settings = Settings.loadSetting();
            settings.setDarkMode(darkMode);
            settings.setFilenameFormat(filenameFormat);
            settings.setPartFormat(partFormat);
            settings.setChapterFormat(chapterFormat);
            settings.setShowHints(showHints);
            settings.save();
            AudiobookConverter.getEnv().setDarkMode(darkMode);
        });
    }

    public void openIssues(ActionEvent actionEvent) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Report bug");
        alert.setContentText("Your setting will be copied into buffer and you will be redirected to GitHub issues page.\nPlease describe your problem and paste settings into the issue.\nNote: Your settings may contain sensitive information like your user name, paths to your files, etc.\n");
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Properties properties = System.getProperties();
            clipboard.setContents(new StringSelection(Utils.propertiesToString(properties) + "\n" + Settings.getRawData()), null);
            AudiobookConverter.getEnv().showDocument("https://github.com/yermak/AudioBookConverter/issues");
        }
    }

    public void repair(ActionEvent actionEvent) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Repair");
        alert.setContentText("Are you sure you want to restore settings to default?\nProgram will be closed.");
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            Settings.clear();
            System.exit(0);
        }
    }

    public void showHints(ActionEvent actionEvent) {
        try {
            AudiobookConverter.loadHints();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

