/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.fx.ConversionContext;
import uk.yermak.audiobookconverter.fx.util.ContextMenuBuilder;
import uk.yermak.audiobookconverter.fx.util.ContextMenuListCell;

public class FileListComponent
extends ListView<MediaInfo> {
    public FileListComponent() {
        this.setCellFactory(ContextMenuListCell.forListView(this.filesContextMenuBuilder()));
        this.getSelectionModel().getSelectedItems().addListener(c -> {
            AudiobookConverter.getContext().getSelectedMedia().clear();
            AudiobookConverter.getContext().getSelectedMedia().addAll((Collection)c.getList());
        });
        ConversionContext context = AudiobookConverter.getContext();
        ObservableList<MediaInfo> media = context.getMedia();
        this.setItems(media);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    void moveFileUp(ActionEvent actionEvent) {
        ObservableList<Integer> selectedIndices = this.getSelectionModel().getSelectedIndices();
        if (selectedIndices.size() == 1) {
            ObservableList items = this.getItems();
            int selected = (Integer)selectedIndices.get(0);
            if (selected > 0) {
                MediaInfo upper = (MediaInfo)items.get(selected - 1);
                MediaInfo lower = (MediaInfo)items.get(selected);
                items.set(selected - 1, (Object)lower);
                items.set(selected, (Object)upper);
                this.getSelectionModel().clearAndSelect(selected - 1);
            }
        }
    }

    private ContextMenuBuilder filesContextMenuBuilder() {
        return new ContextMenuBuilder<MediaInfo>(){

            @Override
            public ContextMenu menu(MediaInfo item) {
                ContextMenu contextMenu = new ContextMenu();
                if (FileListComponent.this.getItems().indexOf((Object)item) != 0) {
                    MenuItem moveUp = new MenuItem("Move up");
                    moveUp.setOnAction((EventHandler<ActionEvent>)((EventHandler)FileListComponent.this::moveFileUp));
                    contextMenu.getItems().add((Object)moveUp);
                }
                if (FileListComponent.this.getItems().size() > FileListComponent.this.getItems().indexOf((Object)item) + 1) {
                    MenuItem moveDown = new MenuItem("Move down");
                    moveDown.setOnAction((EventHandler<ActionEvent>)((EventHandler)FileListComponent.this::moveFileDown));
                    contextMenu.getItems().add((Object)moveDown);
                }
                if (!contextMenu.getItems().isEmpty()) {
                    contextMenu.getItems().add((Object)new SeparatorMenuItem());
                }
                MenuItem removeMenu = new MenuItem("Remove");
                removeMenu.setOnAction((EventHandler<ActionEvent>)((EventHandler)FileListComponent.this::removeFiles));
                contextMenu.getItems().add((Object)removeMenu);
                return contextMenu;
            }
        };
    }

    void moveFileDown(ActionEvent event) {
        ObservableList<Integer> selectedIndices = this.getSelectionModel().getSelectedIndices();
        if (selectedIndices.size() == 1) {
            ObservableList items = this.getItems();
            int selected = (Integer)selectedIndices.get(0);
            if (selected < items.size() - 1) {
                MediaInfo lower = (MediaInfo)items.get(selected + 1);
                MediaInfo upper = (MediaInfo)items.get(selected);
                items.set(selected, (Object)lower);
                items.set(selected + 1, (Object)upper);
                this.getSelectionModel().clearAndSelect(selected + 1);
            }
        }
    }

    void removeFiles(ActionEvent event) {
        ObservableList selected = this.getSelectionModel().getSelectedItems();
        this.getItems().removeAll(selected);
    }

    public void reselect() {
        ConversionContext context = AudiobookConverter.getContext();
        ObservableList<MediaInfo> selectedMedia = context.getSelectedMedia();
        ObservableList<MediaInfo> media = context.getMedia();
        ArrayList<MediaInfo> change = new ArrayList<MediaInfo>((Collection<MediaInfo>)selectedMedia);
        ArrayList selection = new ArrayList(this.getSelectionModel().getSelectedItems());
        if (!change.containsAll(selection) || !selection.containsAll(change)) {
            this.getSelectionModel().clearSelection();
            change.forEach(m -> this.getSelectionModel().select(media.indexOf(m)));
        }
    }
}

