/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.fx.JfxEnv;
import uk.yermak.audiobookconverter.fx.util.Comparators;

public class DialogHelper {
    private static final String M4B = "m4b";
    private static final String M4A = "m4a";
    public static final String MP3 = "mp3";
    public static final String WMA = "wma";
    public static final String FLAC = "flac";
    public static final String AAC = "aac";
    public static final String OGG = "ogg";
    public static final String WAV = "wav";
    private static final String[] FILE_EXTENSIONS = new String[]{"mp3", "m4a", "m4b", "wma", "flac", "ogg", "aac", "wav"};

    static String selectOutputFile(AudioBookInfo audioBookInfo) {
        JfxEnv env = AudiobookConverter.getEnv();
        FileChooser fileChooser = new FileChooser();
        String outputFolder = Settings.loadSetting().getOutputFolder();
        fileChooser.setInitialDirectory(Platform.getInitialDirecotory(outputFolder));
        fileChooser.setInitialFileName(Utils.getOuputFilenameSuggestion(audioBookInfo));
        fileChooser.setTitle("Save AudioBook");
        String formatAsString = AudiobookConverter.getContext().getFormat().toString();
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(formatAsString, new String[]{"*." + formatAsString})});
        File file = fileChooser.showSaveDialog(env.getWindow());
        if (file == null) {
            return null;
        }
        File parentFolder = file.getParentFile();
        Settings.loadSetting().setOutputFolder(parentFolder.getAbsolutePath()).save();
        return file.getPath();
    }

    public static List<String> selectFilesDialog() {
        Window window = AudiobookConverter.getEnv().getWindow();
        FileChooser fileChooser = new FileChooser();
        String sourceFolder = Settings.loadSetting().getSourceFolder();
        fileChooser.setInitialDirectory(Platform.getInitialDirecotory(sourceFolder));
        StringJoiner filetypes = new StringJoiner("/");
        Arrays.stream(FILE_EXTENSIONS).map(String::toUpperCase).forEach(filetypes::add);
        fileChooser.setTitle("Select " + String.valueOf(filetypes) + " files for conversion");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Audio", Arrays.asList(DialogHelper.toSuffixes("*.", FILE_EXTENSIONS))));
        List files = fileChooser.showOpenMultipleDialog(window);
        if (files == null) {
            return null;
        }
        if (!files.isEmpty()) {
            File firstFile = (File)files.get(0);
            File parentFile = firstFile.getParentFile();
            Settings.loadSetting().setSourceFolder(parentFile.getAbsolutePath()).save();
        }
        return DialogHelper.collectFiles(files);
    }

    public static List<String> selectFolderDialog() {
        Window window = AudiobookConverter.getEnv().getWindow();
        DirectoryChooser directoryChooser = new DirectoryChooser();
        String sourceFolder = Settings.loadSetting().getSourceFolder();
        directoryChooser.setInitialDirectory(Platform.getInitialDirecotory(sourceFolder));
        StringJoiner filetypes = new StringJoiner("/");
        Arrays.stream(FILE_EXTENSIONS).map(String::toUpperCase).forEach(filetypes::add);
        directoryChooser.setTitle("Select folder with " + String.valueOf(filetypes) + " files for conversion");
        File selectedDirectory = directoryChooser.showDialog(window);
        if (selectedDirectory == null) {
            return null;
        }
        Settings.loadSetting().setSourceFolder(selectedDirectory.getAbsolutePath()).save();
        return DialogHelper.collectFiles(Collections.singleton(selectedDirectory));
    }

    static List<String> collectFiles(Collection<File> files) {
        ArrayList<String> fileNames = new ArrayList<String>();
        ImmutableSet extensions = ImmutableSet.copyOf((Object[])FILE_EXTENSIONS);
        for (File file : files) {
            if (file.isDirectory()) {
                SuffixFileFilter suffixFileFilter = new SuffixFileFilter(DialogHelper.toSuffixes(".", FILE_EXTENSIONS), IOCase.INSENSITIVE);
                Collection nestedFiles = FileUtils.listFiles((File)file, (IOFileFilter)suffixFileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
                nestedFiles.stream().map(File::getPath).forEach(fileNames::add);
                continue;
            }
            boolean allowedFileExtension = extensions.contains((Object)FilenameUtils.getExtension((String)file.getName()).toLowerCase());
            if (!allowedFileExtension) continue;
            fileNames.add(file.getPath());
        }
        Comparator cmp = Comparators.comparingAlphaDecimal(Comparator.comparing(CharSequence::toString, String::compareToIgnoreCase));
        fileNames.sort(cmp);
        return fileNames;
    }

    private static String[] toSuffixes(String prefix, String[] extensions) {
        String[] suffixes = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            suffixes[i] = prefix + extensions[i];
        }
        return suffixes;
    }
}

