/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.ProgressStatus;

public class ConversionProgress
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    SimpleLongProperty elapsed = new SimpleLongProperty();
    SimpleLongProperty remaining = new SimpleLongProperty();
    SimpleLongProperty size = new SimpleLongProperty();
    SimpleStringProperty filesCount = new SimpleStringProperty();
    SimpleDoubleProperty progress = new SimpleDoubleProperty();
    SimpleStringProperty state = new SimpleStringProperty("");
    private long startTime;
    private boolean finished;
    private final ConversionJob conversionJob;
    private final int totalFiles;
    private int completedFiles;
    private final long totalDuration;
    private final Map<String, Long> durations = new HashMap<String, Long>();
    private final Map<String, Long> sizes = new HashMap<String, Long>();
    private boolean paused;
    private boolean cancelled;
    private long pausePeriod;
    private long pauseTime;

    public ConversionProgress(ConversionJob conversionJob) {
        this.conversionJob = conversionJob;
        this.totalFiles = conversionJob.getConvertable().getMedia().size();
        this.totalDuration = conversionJob.getConvertable().getDuration();
        conversionJob.addStatusChangeListener((ChangeListener<ProgressStatus>)((ChangeListener)(observable, oldValue, newValue) -> {
            switch (newValue) {
                case CANCELLED: {
                    this.cancelled();
                    break;
                }
                case PAUSED: {
                    this.paused();
                    break;
                }
                case IN_PROGRESS: {
                    if (!oldValue.equals((Object)ProgressStatus.PAUSED)) break;
                    this.resumed();
                    break;
                }
                case FINISHED: {
                    this.finished();
                    break;
                }
                case ERROR: {
                    this.error();
                }
            }
        }));
    }

    @Override
    public void run() {
        this.state.set("Converting...");
        this.startTime = System.currentTimeMillis();
        this.filesCount.set(this.completedFiles + "/" + this.totalFiles);
        this.progress.set(0.0);
        this.remaining.set(600000L);
        while (!this.finished && !this.cancelled) {
            if (!this.paused) {
                this.elapsed.set(System.currentTimeMillis() - this.startTime - this.pausePeriod);
            }
            this.silentSleep();
        }
    }

    private void silentSleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void converted(String fileName, long timeInMillis, long size) {
        if (this.paused || this.cancelled) {
            return;
        }
        this.durations.put(fileName, timeInMillis);
        long currentDuration = this.durations.values().stream().mapToLong(d -> d).sum();
        this.sizes.put(fileName, size);
        long estimatedSize = this.sizes.values().stream().mapToLong(l -> l).sum();
        if (currentDuration > 0L && this.totalDuration > 0L) {
            double progress = (double)currentDuration / (double)this.totalDuration;
            long delta = System.currentTimeMillis() - this.pausePeriod - this.startTime;
            long remainingTime = (long)((double)delta / progress) - delta + 1000L;
            this.progress.set(progress);
            this.remaining.set(remainingTime);
            this.size.set((long)((double)estimatedSize / progress));
        }
    }

    public synchronized void incCompleted(String fileName) {
        logger.debug("Completed conversion of file: {}", (Object)fileName);
        ++this.completedFiles;
        if (this.paused || this.cancelled) {
            return;
        }
        if (this.completedFiles == this.totalFiles) {
            this.state.set("Merging chapters...");
            this.progress.set(1.0);
        }
        this.filesCount.set(this.completedFiles + "/" + this.totalFiles);
    }

    private void finished() {
        this.finished = true;
        this.state.set("Completed!");
    }

    private void error() {
        this.finished = true;
        this.state.set("Error!");
    }

    private void cancelled() {
        this.cancelled = true;
        this.durations.clear();
        this.sizes.clear();
        this.progress.set(0.0);
        this.remaining.set(0L);
        this.elapsed.set(0L);
        this.size.set(-1L);
        this.state.set("Cancelled");
    }

    private void paused() {
        this.paused = true;
        this.pauseTime = System.currentTimeMillis();
        this.state.set("Paused");
    }

    private void resumed() {
        this.paused = false;
        this.pausePeriod += System.currentTimeMillis() - this.pauseTime;
        this.state.set("Converting...");
    }

    public void reset() {
        this.durations.clear();
        this.sizes.clear();
        this.progress.set(0.0);
        this.remaining.set(60000L);
    }

    public ConversionJob getConversionJob() {
        return this.conversionJob;
    }

    public void setState(String message) {
        this.state.set(message);
    }
}

