/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionGroup;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.Preset;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Book;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.formats.Format;
import uk.yermak.audiobookconverter.loaders.FFMediaLoader;

public class ConversionContext {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final LinkedList<ConversionJob> conversionQueue = new LinkedList();
    private final SimpleObjectProperty<ConversionGroup> conversionGroupHolder = new SimpleObjectProperty((Object)new ConversionGroup());
    private boolean paused;
    private final ObservableList<MediaInfo> selectedMedia = FXCollections.observableArrayList();
    private final ObservableList<String> genres = FXCollections.observableArrayList();
    private final SimpleObjectProperty<AudioBookInfo> bookInfo = new SimpleObjectProperty((Object)AudioBookInfo.instance());
    private final SimpleObjectProperty<Book> book = new SimpleObjectProperty();
    private final ObservableList<MediaInfo> media = FXCollections.observableArrayList();
    private final ObservableList<ArtWork> posters = FXCollections.observableArrayList();
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private FFMediaLoader mediaLoader;
    private Set<ArtWork> removedArtWorks = new HashSet<ArtWork>();
    private String presetName;
    private SimpleDoubleProperty speed = new SimpleDoubleProperty(1.0);

    public void stopConversions() {
        this.conversionQueue.forEach(ConversionJob::stop);
    }

    public ObservableList<MediaInfo> getSelectedMedia() {
        return this.selectedMedia;
    }

    public void pauseConversions() {
        this.conversionQueue.forEach(ConversionJob::pause);
        this.paused = true;
    }

    public void resumeConversions() {
        this.conversionQueue.forEach(ConversionJob::resume);
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void addJob(ConversionJob conversionJob) {
        this.conversionQueue.add(conversionJob);
        executorService.execute(conversionJob);
    }

    public ObservableList<ArtWork> getPosters() {
        return this.posters;
    }

    public ObservableList<MediaInfo> getMedia() {
        return this.media;
    }

    public ConversionGroup detach() {
        this.mediaLoader.detach();
        ConversionGroup conversionGroup = (ConversionGroup)this.conversionGroupHolder.get();
        conversionGroup.setMedia(new ArrayList<MediaInfo>((Collection<MediaInfo>)this.media));
        conversionGroup.setPosters(new ArrayList<ArtWork>((Collection<ArtWork>)this.posters));
        conversionGroup.setBook((Book)this.book.get());
        conversionGroup.setBookInfo((AudioBookInfo)this.bookInfo.get());
        conversionGroup.setOutputParameters(Preset.copy(String.valueOf(conversionGroup.getGroupId()), Settings.loadSetting().findPreset(this.presetName)));
        conversionGroup.setDetached(true);
        Settings settings = Settings.loadSetting();
        settings.getGenres().add(((AudioBookInfo)this.bookInfo.get()).genre().get());
        settings.save();
        ConversionGroup newConversionGroup = new ConversionGroup();
        this.conversionGroupHolder.set((Object)newConversionGroup);
        this.bookInfo.set((Object)AudioBookInfo.instance());
        this.book.set(null);
        this.posters.clear();
        this.media.clear();
        this.removedArtWorks.clear();
        this.mediaLoader = null;
        return conversionGroup;
    }

    public void addContextDetachListener(InvalidationListener invalidationListener) {
        this.conversionGroupHolder.addListener(invalidationListener);
    }

    public void setBookInfo(AudioBookInfo bookInfo) {
        this.bookInfo.set((Object)bookInfo);
    }

    public void movePosterUp(Integer selected) {
        Platform.runLater(() -> {
            ArtWork lower = (ArtWork)this.posters.get(selected.intValue());
            ArtWork upper = (ArtWork)this.posters.get(selected - 1);
            this.posters.set(selected - 1, (Object)lower);
            this.posters.set(selected.intValue(), (Object)upper);
        });
    }

    public void addPosterIfMissingWithDelay(ArtWork artWork) {
        Platform.runLater(() -> this.addPosterIfMissing(artWork));
    }

    public void addPosterIfMissing(ArtWork artWork) {
        if (this.posters.stream().mapToLong(ArtWork::getCrc32).noneMatch(artWork::matchCrc32)) {
            if (this.removedArtWorks.stream().mapToLong(ArtWork::getCrc32).noneMatch(artWork::matchCrc32)) {
                this.posters.add((Object)artWork);
            }
        }
    }

    public void addBookInfoChangeListener(ChangeListener<AudioBookInfo> listener) {
        this.bookInfo.addListener(listener);
    }

    public void removePoster(int toRemove) {
        Platform.runLater(() -> {
            ArtWork remove = (ArtWork)this.posters.remove(toRemove);
            this.removeArtWork(remove);
        });
    }

    public void addSpeedChangeListener(ChangeListener changeListener) {
        this.speed.addListener(changeListener);
    }

    public void setBook(Book book) {
        this.book.set((Object)book);
    }

    public void addBookChangeListener(ChangeListener<Book> listener) {
        this.book.addListener(listener);
    }

    public AudioBookInfo getBookInfo() {
        return (AudioBookInfo)this.bookInfo.get();
    }

    public Book getBook() {
        return (Book)this.book.get();
    }

    public ConversionGroup getConversionGroup() {
        return (ConversionGroup)this.conversionGroupHolder.get();
    }

    public void addNewMedia(List<MediaInfo> addedMedia) {
        this.getMedia().addAll(addedMedia);
    }

    public Book constructBook(List<MediaInfo> addedMedia) {
        Book book = this.getBook();
        book.construct((List<MediaInfo>)FXCollections.observableArrayList(addedMedia));
        return book;
    }

    public void setMediaLoader(FFMediaLoader mediaLoader) {
        this.mediaLoader = mediaLoader;
    }

    public void removeArtWork(ArtWork artWork) {
        this.removedArtWorks.add(artWork);
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public void setSpeed(double speed) {
        this.speed.set(speed);
    }

    public double getSpeed() {
        return this.speed.get();
    }

    public SimpleDoubleProperty getSpeedObservable() {
        return this.speed;
    }

    public Format getFormat() {
        return Settings.loadSetting().findPreset(this.presetName).getFormat();
    }
}

