/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.Chapter;
import uk.yermak.audiobookconverter.book.MediaInfo;

class ChapterEditor {
    private final Chapter chapter;

    public ChapterEditor(Chapter chapter) {
        this.chapter = chapter;
    }

    void editChapter() {
        Label preview = new Label(this.chapter.getTitle());
        Dialog dialog = new Dialog();
        dialog.setTitle("Edit chapter");
        dialog.setHeaderText("Customise chapter title");
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        HBox customisationBox = new HBox(15.0);
        grid.add((Node)customisationBox, 0, 0);
        HashMap<String, Function<Chapter, Object>> context = new HashMap<String, Function<Chapter, Object>>(this.chapter.getRenderMap());
        CheckBox bookNo = new CheckBox("Book No");
        bookNo.setSelected(context.containsKey("BOOK_NUMBER"));
        bookNo.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (bookNo.isSelected()) {
                context.put("BOOK_NUMBER", c -> String.valueOf((Object)c.getPart().getBook().getBookInfo().bookNumber()));
            } else {
                context.remove("BOOK_NUMBER");
            }
            Platform.runLater(() -> preview.setText(Utils.renderChapter(this.chapter, context)));
        }));
        customisationBox.getChildren().add((Object)bookNo);
        CheckBox bookTitle = new CheckBox("Book title");
        bookTitle.setSelected(context.containsKey("BOOK_TITLE"));
        customisationBox.getChildren().add((Object)bookTitle);
        bookTitle.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (bookTitle.isSelected()) {
                context.put("BOOK_TITLE", c -> c.getPart().getBook().getBookInfo().title());
            } else {
                context.remove("BOOK_TITLE");
            }
            Platform.runLater(() -> preview.setText(Utils.renderChapter(this.chapter, context)));
        }));
        CheckBox chapterText = new CheckBox("\"Chapter\"");
        chapterText.setSelected(context.containsKey("CHAPTER_TEXT"));
        customisationBox.getChildren().add((Object)chapterText);
        chapterText.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (chapterText.isSelected()) {
                context.put("CHAPTER_TEXT", c -> "Chapter");
            } else {
                context.remove("CHAPTER_TEXT");
            }
            Platform.runLater(() -> preview.setText(Utils.renderChapter(this.chapter, context)));
        }));
        CheckBox chapterNo = new CheckBox("Chapter No");
        chapterNo.setSelected(context.containsKey("CHAPTER_NUMBER"));
        chapterNo.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (chapterNo.isSelected()) {
                context.put("CHAPTER_NUMBER", Chapter::getNumber);
            } else {
                context.remove("CHAPTER_NUMBER");
            }
            Platform.runLater(() -> preview.setText(Utils.renderChapter(this.chapter, context)));
        }));
        customisationBox.getChildren().add((Object)chapterNo);
        ComboBox tagsSelection = new ComboBox();
        tagsSelection.getItems().addAll((Object[])new String[]{"None", "title", "artist", "album_artist", "album", "genre", "year", "comment-0", "file_name"});
        AtomicInteger selected = new AtomicInteger();
        context.keySet().stream().filter(s -> s.contains("TAG")).mapToInt(value -> Integer.parseInt(value.substring(4))).findAny().ifPresent(selected::set);
        tagsSelection.getSelectionModel().select(selected.get());
        customisationBox.getChildren().add((Object)new HBox(5.0, new Node[]{tagsSelection, new Label("MP3 tag")}));
        tagsSelection.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> {
            switch (newValue.intValue()) {
                case 0: {
                    for (int i = 1; i < 9; ++i) {
                        context.remove("TAG." + i);
                    }
                    break;
                }
                case 1: {
                    for (int i = 1; i < 9; ++i) {
                        context.remove("TAG." + i);
                    }
                    context.put("TAG.1", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().title());
                    break;
                }
                case 2: {
                    for (int i = 1; i < 9; ++i) {
                        context.remove("TAG." + i);
                    }
                    context.put("TAG.2", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().writer());
                    break;
                }
                case 3: {
                    for (int i = 1; i < 9; ++i) {
                        context.remove("TAG." + i);
                    }
                    context.put("TAG.3", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().narrator());
                    break;
                }
                case 4: {
                    for (int i = 1; i < 9; ++i) {
                        context.remove("TAG." + i);
                    }
                    context.put("TAG.4", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().series());
                    break;
                }
                case 5: {
                    for (int i = 1; i < 9; ++i) {
                        context.remove("TAG." + i);
                    }
                    context.put("TAG.5", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().genre());
                    break;
                }
                case 6: {
                    for (int i = 1; i < 9; ++i) {
                        context.remove("TAG." + i);
                    }
                    context.put("TAG.6", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().year());
                    break;
                }
                case 7: {
                    for (int i = 1; i < 9; ++i) {
                        context.remove("TAG." + i);
                    }
                    context.put("TAG.7", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().comment());
                    break;
                }
                case 8: {
                    for (int i = 1; i < 9; ++i) {
                        context.remove("TAG." + i);
                    }
                    context.put("TAG.8", chapter -> FilenameUtils.getBaseName((String)((MediaInfo)chapter.getMedia().get(0)).getFileName()));
                }
            }
            Platform.runLater(() -> preview.setText(Utils.renderChapter(this.chapter, context)));
        });
        TextField customTitle = new TextField();
        customTitle.setPromptText("custom title");
        customTitle.setText(this.chapter.getCustomTitle());
        customTitle.textProperty().addListener((observable, oldValue, newValue) -> {
            if (StringUtils.trimToNull((String)newValue) != null) {
                context.put("CUSTOM_TITLE", c -> newValue);
            } else {
                context.remove("CUSTOM_TITLE");
            }
            Platform.runLater(() -> preview.setText(Utils.renderChapter(this.chapter, context)));
        });
        customisationBox.getChildren().add((Object)customTitle);
        CheckBox duration = new CheckBox("Duration");
        duration.setSelected(context.containsKey("DURATION"));
        customisationBox.getChildren().add((Object)duration);
        duration.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (duration.isSelected()) {
                context.put("DURATION", c -> Duration.ofMillis(c.getDuration()));
            } else {
                context.remove("DURATION");
            }
            Platform.runLater(() -> preview.setText(Utils.renderChapter(this.chapter, context)));
        }));
        grid.add((Node)preview, 0, 1);
        CheckBox applyForAllChapters = new CheckBox("Apply for all chapters");
        grid.add((Node)applyForAllChapters, 0, 2);
        CheckBox saveAsDefault = new CheckBox("Apply and save as default for all books");
        grid.add((Node)saveAsDefault, 0, 3);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> preview.setText(Utils.renderChapter(this.chapter, context)));
        Optional result = dialog.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            this.chapter.getRenderMap().clear();
            this.chapter.getRenderMap().putAll(context);
            this.chapter.setCustomTitle(StringUtils.trimToEmpty((String)customTitle.getText()));
            if (StringUtils.isNotEmpty((CharSequence)customTitle.getText())) {
                this.chapter.getRenderMap().put("CUSTOM_TITLE", Chapter::getCustomTitle);
            }
            if (applyForAllChapters.isSelected() || saveAsDefault.isSelected()) {
                this.applyForAllChapters(context, customTitle);
            }
            if (saveAsDefault.isSelected()) {
                String defaultChapterContext = String.join((CharSequence)":", context.keySet());
                Settings.loadSetting().setChapterContext(defaultChapterContext).save();
                Settings.loadSetting().setChapterCustomTitle(StringUtils.trimToNull((String)customTitle.getText())).save();
            }
        }
    }

    private void applyForAllChapters(Map<String, Function<Chapter, Object>> context, TextField customTitle) {
        List<Chapter> chapters = this.chapter.getPart().getBook().getChapters();
        for (Chapter c : chapters) {
            c.getRenderMap().clear();
            c.getRenderMap().putAll(context);
            if (StringUtils.isNotEmpty((CharSequence)customTitle.getText())) {
                c.getRenderMap().put("CUSTOM_TITLE", Chapter::getCustomTitle);
            }
            c.setCustomTitle(customTitle.getText());
        }
    }
}

