/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.book.Book;
import uk.yermak.audiobookconverter.book.Chapter;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.Organisable;
import uk.yermak.audiobookconverter.book.Part;
import uk.yermak.audiobookconverter.book.Track;
import uk.yermak.audiobookconverter.fx.ChapterEditor;
import uk.yermak.audiobookconverter.fx.SubTracksDialog;
import uk.yermak.audiobookconverter.fx.util.ContextMenuBuilder;
import uk.yermak.audiobookconverter.fx.util.ContextMenuTreeTableRow;

public class BookStructureComponent
extends TreeTableView<Organisable> {
    public BookStructureComponent() {
        this.setRowFactory(ContextMenuTreeTableRow.forListView(this.buildChaptersContextMenu()));
    }

    private ContextMenuBuilder buildChaptersContextMenu() {
        return new ContextMenuBuilder<Organisable>(){

            @Override
            public ContextMenu menu(Organisable item) {
                MenuItem split;
                ContextMenu contextMenu = new ContextMenu();
                if (item instanceof Chapter && BookStructureComponent.this.getSelectionModel().getSelectedItems().size() == 1) {
                    MenuItem edit = new MenuItem("Edit");
                    edit.setOnAction((EventHandler<ActionEvent>)((EventHandler)BookStructureComponent.this::editChapter));
                    contextMenu.getItems().add((Object)edit);
                }
                if (!contextMenu.getItems().isEmpty() && !(contextMenu.getItems().get(contextMenu.getItems().size() - 1) instanceof SeparatorMenuItem)) {
                    contextMenu.getItems().add((Object)new SeparatorMenuItem());
                }
                if (item.getTotalNumbers() > 1 && item.getNumber() > 1 && BookStructureComponent.this.getSelectionModel().getSelectedItems().size() == 1) {
                    MenuItem moveUp = new MenuItem("Move up");
                    moveUp.setOnAction((EventHandler<ActionEvent>)((EventHandler)BookStructureComponent.this::moveChapterUp));
                    contextMenu.getItems().add((Object)moveUp);
                }
                if (item.getTotalNumbers() > 1 && item.getNumber() < item.getTotalNumbers() && BookStructureComponent.this.getSelectionModel().getSelectedItems().size() == 1) {
                    MenuItem moveDown = new MenuItem("Move down");
                    moveDown.setOnAction((EventHandler<ActionEvent>)((EventHandler)BookStructureComponent.this::moveChapterDown));
                    contextMenu.getItems().add((Object)moveDown);
                }
                if (!contextMenu.getItems().isEmpty() && !(contextMenu.getItems().get(contextMenu.getItems().size() - 1) instanceof SeparatorMenuItem)) {
                    contextMenu.getItems().add((Object)new SeparatorMenuItem());
                }
                if (item instanceof MediaInfo && item.getTotalNumbers() > 1 && item.getNumber() > 1 && BookStructureComponent.this.getSelectionModel().getSelectedItems().size() == 1) {
                    split = new MenuItem("Split to new chapter");
                    split.setOnAction((EventHandler<ActionEvent>)((EventHandler)BookStructureComponent.this::split));
                    contextMenu.getItems().add((Object)split);
                }
                if ((item instanceof Chapter || item instanceof Part) && item.getTotalNumbers() > 1 && BookStructureComponent.this.getSelectionModel().getSelectedItems().size() > 1) {
                    MenuItem combine = new MenuItem("Combine");
                    combine.setOnAction((EventHandler<ActionEvent>)((EventHandler)BookStructureComponent.this::combineChapters));
                    contextMenu.getItems().add((Object)combine);
                }
                if (item instanceof Chapter && item.getTotalNumbers() > 1 && BookStructureComponent.this.getSelectionModel().getSelectedItems().size() == 1) {
                    split = new MenuItem("Split to new part");
                    split.setOnAction((EventHandler<ActionEvent>)((EventHandler)BookStructureComponent.this::split));
                    contextMenu.getItems().add((Object)split);
                }
                if (!contextMenu.getItems().isEmpty() && !(contextMenu.getItems().get(contextMenu.getItems().size() - 1) instanceof SeparatorMenuItem)) {
                    contextMenu.getItems().add((Object)new SeparatorMenuItem());
                }
                if (item instanceof MediaInfo && BookStructureComponent.this.getSelectionModel().getSelectedItems().size() == 1) {
                    MenuItem subTracks = new MenuItem("Sub-tracks");
                    subTracks.setOnAction((EventHandler<ActionEvent>)((EventHandler)BookStructureComponent.this::subTracks));
                    contextMenu.getItems().add((Object)subTracks);
                }
                if (!contextMenu.getItems().isEmpty() && !(contextMenu.getItems().get(contextMenu.getItems().size() - 1) instanceof SeparatorMenuItem)) {
                    contextMenu.getItems().add((Object)new SeparatorMenuItem());
                }
                MenuItem removeMenu = new MenuItem("Remove");
                removeMenu.setOnAction((EventHandler<ActionEvent>)((EventHandler)BookStructureComponent.this::removeChapters));
                contextMenu.getItems().add((Object)removeMenu);
                return contextMenu;
            }
        };
    }

    public void editChapter(ActionEvent actionEvent) {
        ObservableList selectedCells = this.getSelectionModel().getSelectedCells();
        if (selectedCells.size() != 1) {
            return;
        }
        Organisable organisable = (Organisable)((TreeTablePosition)selectedCells.get(0)).getTreeItem().getValue();
        if (organisable instanceof Chapter) {
            new ChapterEditor((Chapter)organisable).editChapter();
            this.refresh();
        }
    }

    void moveChapterUp(ActionEvent event) {
        ObservableList selectedCells = this.getSelectionModel().getSelectedCells();
        if (selectedCells.size() == 1) {
            Organisable organisable = (Organisable)((TreeTablePosition)selectedCells.get(0)).getTreeItem().getValue();
            organisable.moveUp();
            Platform.runLater(this::updateBookStructure);
        }
    }

    void updateBookStructure() {
        Book book = AudiobookConverter.getContext().getBook();
        this.getRoot().getChildren().clear();
        book.getParts().forEach(p -> {
            TreeItem<Part> partItem = new TreeItem<Part>((Part)p);
            this.getRoot().getChildren().add(partItem);
            p.getChapters().forEach(c -> {
                TreeItem<Chapter> chapterItem = new TreeItem<Chapter>((Chapter)c);
                partItem.getChildren().add(chapterItem);
                c.getMedia().forEach(m -> chapterItem.getChildren().add(new TreeItem<MediaInfo>((MediaInfo)m)));
            });
        });
        this.getRoot().getChildren().forEach(t -> t.setExpanded(true));
        this.refresh();
    }

    void moveChapterDown(ActionEvent event) {
        ObservableList selectedCells = this.getSelectionModel().getSelectedCells();
        if (selectedCells.size() == 1) {
            Organisable organisable = (Organisable)((TreeTablePosition)selectedCells.get(0)).getTreeItem().getValue();
            organisable.moveDown();
            Platform.runLater(this::updateBookStructure);
        }
    }

    void split(ActionEvent event) {
        ObservableList selectedCells = this.getSelectionModel().getSelectedCells();
        if (selectedCells.size() != 1) {
            return;
        }
        Organisable organisable = (Organisable)((TreeTablePosition)selectedCells.get(0)).getTreeItem().getValue();
        boolean split = organisable.split();
        if (split) {
            this.updateBookStructure();
        }
    }

    void combineChapters(ActionEvent event) {
        ObservableList selectedCells = this.getSelectionModel().getSelectedCells();
        if (selectedCells.isEmpty()) {
            return;
        }
        List<Part> partMergers = selectedCells.stream().map(s -> (Organisable)s.getTreeItem().getValue()).filter(v -> v instanceof Part).map(c -> (Part)c).collect(Collectors.toList());
        if (partMergers.size() > 1) {
            Part recipient = (Part)partMergers.remove(0);
            recipient.combine(partMergers);
        } else {
            List<Chapter> chapterMergers = selectedCells.stream().map(s -> (Organisable)s.getTreeItem().getValue()).filter(v -> v instanceof Chapter).map(c -> (Chapter)c).collect(Collectors.toList());
            if (chapterMergers.size() > 1) {
                Chapter recipient = (Chapter)chapterMergers.remove(0);
                recipient.combine(chapterMergers);
            }
        }
        this.updateBookStructure();
        this.getSelectionModel().clearSelection();
    }

    void subTracks(ActionEvent actionEvent) {
        ObservableList selectedCells = this.getSelectionModel().getSelectedCells();
        if (selectedCells.size() != 1) {
            return;
        }
        Organisable organisable = (Organisable)((TreeTablePosition)selectedCells.get(0)).getTreeItem().getValue();
        if (organisable instanceof MediaInfo) {
            SubTracksDialog dialog = new SubTracksDialog(AudiobookConverter.getEnv().getWindow());
            Optional result = dialog.showAndWait();
            result.ifPresent(r -> {
                MediaInfo mediaInfo = (MediaInfo)organisable;
                this.extractSubtracks(mediaInfo, (Boolean)r.get("autoChapters"), (Integer)r.get("interval") * 1000, (Boolean)r.get("repeat"));
                this.updateBookStructure();
            });
        }
    }

    private void extractSubtracks(MediaInfo mediaInfo, Boolean wrapWithChapters, long interval, Boolean repeat) {
        double speed = AudiobookConverter.getContext().getSpeed();
        long duration = mediaInfo.getDuration();
        if (speed != 1.0) {
            interval = (long)((double)interval * speed);
            duration = (long)((double)duration * speed);
        }
        long fullTracks = duration / interval;
        ArrayList<Track> tracks = new ArrayList<Track>();
        if (repeat.booleanValue()) {
            long count = fullTracks + (long)(duration % interval > 0L ? 1 : 0);
            int i = 1;
            while ((long)i <= count) {
                Track track = new Track(String.valueOf(i));
                track.setTitle(mediaInfo.getTitle());
                track.setStart((long)(i - 1) * interval);
                track.setEnd(Math.min((long)i * interval - 1L, duration));
                tracks.add(track);
                ++i;
            }
        } else if (interval < duration) {
            Track startTrack = new Track(String.valueOf(1));
            startTrack.setTitle(mediaInfo.getTitle());
            startTrack.setStart(0L);
            startTrack.setEnd(interval);
            tracks.add(startTrack);
            Track endTrack = new Track(String.valueOf(2));
            endTrack.setTitle(mediaInfo.getTitle());
            endTrack.setStart(interval);
            endTrack.setEnd(duration);
            tracks.add(endTrack);
        }
        if (wrapWithChapters.booleanValue()) {
            Part part = mediaInfo.getChapter().getPart();
            part.replaceMediaChapterByTracksChapters(mediaInfo, tracks);
        } else {
            Chapter chapter = mediaInfo.getChapter();
            chapter.replaceMediaWithTracks(mediaInfo, tracks);
        }
    }

    void removeChapters(ActionEvent event) {
        ObservableList selectedCells = this.getSelectionModel().getSelectedCells();
        for (TreeTablePosition selectedCell : selectedCells) {
            Organisable organisable = (Organisable)selectedCell.getTreeItem().getValue();
            organisable.remove();
        }
        Platform.runLater(() -> {
            this.updateBookStructure();
            this.getSelectionModel().clearSelection();
        });
    }
}

