/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import org.apache.commons.lang3.StringUtils;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.fx.util.TextFieldValidator;

public class BookInfoController {
    @FXML
    private TextField title;
    @FXML
    private TextField writer;
    @FXML
    private TextField narrator;
    @FXML
    private ComboBox<String> genre;
    @FXML
    private TextField series;
    @FXML
    private TextField bookNo;
    @FXML
    private TextField year;
    @FXML
    private TextField comment;

    @FXML
    private void initialize() {
        MenuItem menuItem = new MenuItem("Remove");
        Settings settings = Settings.loadSetting();
        this.genre.setItems((ObservableList<String>)FXCollections.observableArrayList(settings.getGenres()));
        menuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            String remove = (String)this.genre.getItems().get(this.genre.getSelectionModel().getSelectedIndex());
            settings.getGenres().remove(remove);
            settings.save();
            this.genre.getItems().remove((Object)remove);
        }));
        AudiobookConverter.getContext().addContextDetachListener(observable -> this.genre.setItems((ObservableList<String>)FXCollections.observableArrayList(Settings.loadSetting().getGenres())));
        ContextMenu contextMenu = new ContextMenu(menuItem);
        this.genre.setOnContextMenuRequested(event -> {
            if (!this.genre.getSelectionModel().isEmpty()) {
                contextMenu.show((Node)event.getSource(), Side.RIGHT, 0.0, 0.0);
            }
            this.genre.hide();
        });
        ObservableList<MediaInfo> media = AudiobookConverter.getContext().getMedia();
        media.addListener(change -> this.updateTags(media, media.isEmpty()));
        this.bookNo.setTextFormatter(new TextFieldValidator(TextFieldValidator.ValidationModus.MAX_INTEGERS, 3).getFormatter());
        this.year.setTextFormatter(new TextFieldValidator(TextFieldValidator.ValidationModus.MAX_INTEGERS, 4).getFormatter());
        this.title.textProperty().addListener(o -> AudiobookConverter.getContext().getBookInfo().title().set(this.title.getText()));
        this.writer.textProperty().addListener(o -> AudiobookConverter.getContext().getBookInfo().writer().set(this.writer.getText()));
        this.narrator.textProperty().addListener(o -> AudiobookConverter.getContext().getBookInfo().narrator().set(this.narrator.getText()));
        this.genre.valueProperty().addListener(o -> AudiobookConverter.getContext().getBookInfo().genre().set((String)this.genre.getValue()));
        this.genre.getEditor().textProperty().addListener(o -> AudiobookConverter.getContext().getBookInfo().genre().set(this.genre.getEditor().getText()));
        this.series.textProperty().addListener(o -> AudiobookConverter.getContext().getBookInfo().series().set(this.series.getText()));
        this.bookNo.textProperty().addListener(o -> {
            if (StringUtils.isNotBlank((CharSequence)this.bookNo.getText())) {
                AudiobookConverter.getContext().getBookInfo().bookNumber().set(this.bookNo.getText());
            }
        });
        this.year.textProperty().addListener(o -> AudiobookConverter.getContext().getBookInfo().year().set(this.year.getText()));
        this.comment.textProperty().addListener(o -> AudiobookConverter.getContext().getBookInfo().comment().set(this.comment.getText()));
        AudiobookConverter.getContext().addContextDetachListener(observable -> Platform.runLater(this::clearTags));
    }

    private void updateTags(ObservableList<MediaInfo> media, boolean clear) {
        if (AudiobookConverter.getContext().getBook() == null) {
            if (clear) {
                this.clearTags();
            } else {
                Executors.newSingleThreadExecutor().submit(() -> {
                    AudioBookInfo info = ((MediaInfo)media.get(0)).getBookInfo();
                    Platform.runLater(() -> this.copyTags(info));
                });
            }
        }
    }

    private void copyTags(AudioBookInfo bookInfo) {
        this.title.setText(bookInfo.series().get());
        this.writer.setText(bookInfo.writer().get());
        this.narrator.setText(bookInfo.narrator().get());
        this.genre.getEditor().setText(bookInfo.genre().get());
        this.series.setText(bookInfo.series().get());
        this.bookNo.setText(bookInfo.bookNumber().get());
        this.year.setText(bookInfo.year().get());
        this.comment.setText(bookInfo.comment().get());
    }

    private void clearTags() {
        this.title.setText("");
        this.writer.setText("");
        this.narrator.setText("");
        this.genre.getEditor().setText("");
        this.series.setText("");
        this.bookNo.setText("");
        this.year.setText("");
        this.comment.setText("");
    }
}

