/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import uk.yermak.audiobookconverter.book.ArtWork;

public class ArtWorkListCell
extends ListCell<ArtWork> {
    private final ImageView imageView = new ImageView();

    @Override
    public void updateItem(ArtWork artWork, boolean empty) {
        super.updateItem(artWork, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            try (FileInputStream imageStream = new FileInputStream(artWork.getFileName());){
                Image image = new Image((InputStream)imageStream);
                this.imageView.setImage(image);
                this.imageView.setFitHeight(110.0);
                this.imageView.setPreserveRatio(true);
                this.imageView.setSmooth(true);
                double height = image.getHeight();
                double width = image.getWidth();
                this.setTooltip(new Tooltip("[" + Math.round(width) + "x" + Math.round(height) + "] - " + artWork.getFileName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setGraphic((Node)this.imageView);
        }
    }
}

