/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.fx;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.fx.ArtWorkListCell;
import uk.yermak.audiobookconverter.fx.ConversionContext;
import uk.yermak.audiobookconverter.loaders.ArtWorkImage;

public class ArtWorkController {
    @FXML
    ListView<ArtWork> imageList;
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @FXML
    private void initialize() {
        ConversionContext context = AudiobookConverter.getContext();
        this.imageList.setCellFactory((Callback<ListView<ArtWork>, ListCell<ArtWork>>)((Callback)param -> new ArtWorkListCell()));
        this.imageList.setItems(context.getPosters());
        context.addContextDetachListener(observable -> context.getPosters().clear());
    }

    @FXML
    private void addImage(ActionEvent actionEvent) {
        FileChooser fileChooser = new FileChooser();
        String sourceFolder = Settings.loadSetting().getSourceFolder();
        fileChooser.setInitialDirectory(Platform.getInitialDirecotory(sourceFolder));
        fileChooser.setTitle("Select JPG or PNG file");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("jpg", new String[]{"*.jpg", "*.jpeg", "*.jfif"}), new FileChooser.ExtensionFilter("png", new String[]{"*.png"}), new FileChooser.ExtensionFilter("bmp", new String[]{"*.bmp"})});
        File file = fileChooser.showOpenDialog(AudiobookConverter.getEnv().getWindow());
        logger.debug("Opened dialog for art image in folder: {}", (Object)sourceFolder);
        if (file != null) {
            try (FileInputStream imageStream = new FileInputStream(file.getAbsolutePath());){
                this.imageList.getItems().add((Object)new ArtWorkImage(new javafx.scene.image.Image((InputStream)imageStream)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            logger.info("Added art work from file: {}", (Object)file);
        }
    }

    @FXML
    private void removeImage(ActionEvent actionEvent) {
        int toRemove = this.imageList.getSelectionModel().getSelectedIndex();
        if (toRemove == -1) {
            return;
        }
        AudiobookConverter.getContext().removePoster(toRemove);
        logger.info("Removed art work #{}", (Object)toRemove);
    }

    @FXML
    private void left(ActionEvent actionEvent) {
        Integer selected;
        ObservableList<Integer> selectedIndices = this.imageList.getSelectionModel().getSelectedIndices();
        if (selectedIndices.size() == 1 && (selected = (Integer)selectedIndices.get(0)) > 0) {
            AudiobookConverter.getContext().movePosterUp(selected);
            this.imageList.getSelectionModel().clearAndSelect(selected - 1);
            logger.debug("Image {} moved left", (Object)selected);
        }
    }

    @FXML
    private void right(ActionEvent actionEvent) {
        ObservableList<Integer> selectedIndices = this.imageList.getSelectionModel().getSelectedIndices();
        if (selectedIndices.size() == 1) {
            ObservableList<ArtWork> items = this.imageList.getItems();
            Integer selected = (Integer)selectedIndices.get(0);
            if (selected < items.size() - 1) {
                AudiobookConverter.getContext().movePosterUp(selected + 1);
                this.imageList.getSelectionModel().clearAndSelect(selected + 1);
                logger.debug("Image {} moved right", (Object)selected);
            }
        }
    }

    public void pasteImage(ActionEvent actionEvent) {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null) {
                if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                    javafx.scene.image.Image fimage = ArtWorkController.awtImageToFX(image);
                    AudiobookConverter.getContext().addPosterIfMissingWithDelay(new ArtWorkImage(fimage));
                } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List artFiles = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    artFiles.stream().filter(s -> ArrayUtils.contains((Object[])ArtWork.IMAGE_EXTENSIONS, (Object)FilenameUtils.getExtension((String)s))).forEach(f -> {
                        try (FileInputStream imageStream = new FileInputStream((String)f);){
                            AudiobookConverter.getContext().addPosterIfMissingWithDelay(new ArtWorkImage(new javafx.scene.image.Image((InputStream)imageStream)));
                        }
                        catch (IOException e) {
                            logger.error("failed to paste image", (Throwable)e);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to load from clipboard", (Throwable)e);
            e.printStackTrace();
        }
    }

    private static javafx.scene.image.Image awtImageToFX(Image image) throws Exception {
        if (!(image instanceof RenderedImage)) {
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            image = bufferedImage;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            javafx.scene.image.Image image2;
            ImageIO.write((RenderedImage)((Object)image), "png", out);
            out.flush();
            try (ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());){
                image2 = new javafx.scene.image.Image((InputStream)in);
            }
            return image2;
        }
    }
}

