/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.formats;

import java.lang.invoke.MethodHandles;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.formats.Format;

public class OutputParameters {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Format format = Format.M4B;
    protected Integer bitRate = this.format.defaultBitrate();
    protected Integer frequency = this.format.defaultFrequency();
    protected Integer channels = this.format.defaultChannel();
    protected Integer vbrQuality = this.format.defaultVbrQuality();
    protected boolean cbr = this.format.defaultCBR();
    protected Integer cutoff = this.format.defaultCutoff();
    protected Double speed = this.format.defaultSpeed();
    protected Force force = Force.Auto;
    private boolean splitChapters = false;

    public OutputParameters() {
    }

    public OutputParameters(Format format, int bitRate, int frequency, int channels, int cutoff, boolean cbr, int quality, double speed, Force force, boolean splitChapters) {
        this.format = format;
        this.bitRate = bitRate;
        this.frequency = frequency;
        this.channels = channels;
        this.vbrQuality = quality;
        this.cbr = cbr;
        this.cutoff = cutoff;
        this.speed = speed;
        this.force = force;
        this.splitChapters = splitChapters;
    }

    public OutputParameters(OutputParameters parameters) {
        this(parameters.getFormat(), parameters.getBitRate(), parameters.getFrequency(), parameters.getChannels(), parameters.getCutoff(), parameters.isCbr(), parameters.getVbrQuality(), parameters.getSpeed(), parameters.getForce(), parameters.isSplitChapters());
    }

    public boolean needReencode(String codec) {
        return switch (this.force.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.format.needsReencode(codec);
            case 1 -> true;
            case 2 -> !this.format.skipReedncode(codec);
        };
    }

    public void setupFormat(Format format) {
        this.format = format;
    }

    public Integer getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(Integer bitRate) {
        this.bitRate = OutputParameters.findNearestMatch(bitRate, this.format.bitrates(), this.format.defaultBitrate());
    }

    public Integer getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = OutputParameters.findNearestMatch(frequency, this.format.frequencies(), this.format.defaultFrequency());
    }

    private static Integer findNearestMatch(int value, List<Integer> list, int defaultValue) {
        for (Integer integer : list) {
            if (integer < value) continue;
            return integer;
        }
        return defaultValue;
    }

    public Integer getChannels() {
        return this.channels;
    }

    public void setChannels(Integer channels) {
        this.channels = OutputParameters.findNearestMatch(channels, this.format.channels(), this.format.defaultChannel());
    }

    public Integer getVbrQuality() {
        return this.vbrQuality;
    }

    public void setVbrQuality(Integer vbrQuality) {
        this.vbrQuality = OutputParameters.findNearestMatch(vbrQuality, this.format.vbrQualities(), this.format.defaultVbrQuality());
    }

    public Boolean isCbr() {
        return this.cbr;
    }

    public void setCbr(Boolean cbr) {
        this.cbr = cbr;
    }

    public Integer getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(Integer cutoff) {
        this.cutoff = cutoff;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isSplitChapters() {
        return this.splitChapters;
    }

    public void setSplitChapters(boolean splitChapters) {
        this.splitChapters = splitChapters;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public ObservableValue<Double> getSpeedObservable() {
        return new SimpleObjectProperty((Object)this.speed);
    }

    protected void initSpeed() {
        this.speed = 1.0;
    }

    public void setForce(Force force) {
        this.force = force;
    }

    public Force getForce() {
        return this.force;
    }

    public static enum Force {
        Auto,
        Always,
        Avoid;

    }
}

