/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.formats;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionException;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Convertable;
import uk.yermak.audiobookconverter.formats.FlacPicture;
import uk.yermak.audiobookconverter.formats.Format;
import uk.yermak.audiobookconverter.formats.OutputParameters;

public class OGGFormat
extends Format {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Map<Integer, Integer> VBR_MAP = ImmutableMap.of((Object)1, (Object)8, (Object)2, (Object)16, (Object)3, (Object)32, (Object)4, (Object)64, (Object)5, (Object)128);
    public static final List<Integer> FREQUENCIES = List.of(Integer.valueOf(8000), Integer.valueOf(12000), Integer.valueOf(16000), Integer.valueOf(24000), Integer.valueOf(32000), Integer.valueOf(48000));
    public static final List<Integer> BITRATES = List.of(16, 24, 32, 48, 56, 64, 96, 112, 128, 144, 160, 192, 224, 256, 320, 512);

    OGGFormat() {
        super("ogg", "libopus", "ogg", "vorbis");
    }

    @Override
    public List<Integer> frequencies() {
        return FREQUENCIES;
    }

    @Override
    public List<Integer> bitrates() {
        return BITRATES;
    }

    @Override
    public Double defaultSpeed() {
        return 1.0;
    }

    @Override
    public Integer defaultChannel() {
        return 2;
    }

    @Override
    public Integer defaultVbrQuality() {
        return 3;
    }

    @Override
    public Integer defaultBitrate() {
        return 64;
    }

    @Override
    public Integer defaultCutoff() {
        return 8000;
    }

    @Override
    public Integer defaultFrequency() {
        return 48000;
    }

    @Override
    public Boolean defaultCBR() {
        return false;
    }

    @Override
    protected void setBitRateOptions(List<String> options, OutputParameters outputParameters) {
        if (outputParameters.cbr) {
            options.addAll(List.of("-b:a", outputParameters.getBitRate() + "k"));
            options.addAll(List.of("-vbr", "off"));
        } else {
            options.addAll(List.of("-b:a", VBR_MAP.get(outputParameters.getVbrQuality()) * outputParameters.getChannels() + "k"));
            options.addAll(List.of("-vbr", "on"));
        }
        options.add("-frame_duration");
        options.add("60");
    }

    @Override
    public boolean mp4Compatible() {
        return false;
    }

    @Override
    public boolean ffmpegCompatible() {
        return true;
    }

    @Override
    public List<String> getConcatOptions(String fileListFileName, String outputFileName, String progressUri, ConversionJob conversionJob) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(Platform.FFMPEG);
        options.add("-protocol_whitelist");
        options.add("file,pipe,concat");
        options.add("-f");
        options.add("concat");
        options.add("-safe");
        options.add("0");
        options.add("-i");
        options.add(fileListFileName);
        options.add("-i");
        options.add(this.prepareOggMetaFile(conversionJob));
        options.add("-map_metadata");
        options.add("1");
        options.add("-c:a");
        options.add("copy");
        options.add("-vn");
        options.add("-f");
        options.add(this.name);
        options.add("-progress");
        options.add(progressUri);
        options.add(outputFileName);
        return options;
    }

    private String prepareOggMetaFile(ConversionJob conversionJob) {
        AudioBookInfo bookInfo = conversionJob.getConversionGroup().getBookInfo();
        List<ArtWork> posters = conversionJob.getConversionGroup().getPosters();
        Convertable convertable = conversionJob.getConvertable();
        long groupId = conversionJob.getConversionGroup().getGroupId();
        try {
            File metaFile = new File(System.getProperty("java.io.tmpdir"), "FFMETADATAFILE" + groupId);
            ArrayList<Object> metaData = new ArrayList<Object>();
            metaData.add(";FFMETADATA1");
            metaData.add("major_brand=OGG");
            metaData.add("title=" + String.valueOf((Object)bookInfo.title()) + (String)(convertable.isTheOnlyOne() ? "" : "-" + convertable.getNumber()));
            if (bookInfo.writer().isNotBlank()) {
                metaData.add("artist=" + String.valueOf((Object)bookInfo.writer()));
            }
            if (bookInfo.series().isNotBlank()) {
                metaData.add("album=" + String.valueOf((Object)bookInfo.series()));
            } else if (bookInfo.title().isNotBlank()) {
                metaData.add("album=" + String.valueOf((Object)bookInfo.title()));
            }
            if (bookInfo.narrator().isNotBlank()) {
                metaData.add("composer=" + String.valueOf((Object)bookInfo.narrator()));
            }
            if (bookInfo.year().isNotBlank()) {
                metaData.add("date=" + String.valueOf((Object)bookInfo.year()));
            }
            if (bookInfo.comment().isNotBlank()) {
                metaData.add("comment=" + String.valueOf((Object)bookInfo.comment()));
            }
            if (bookInfo.genre().isNotBlank()) {
                metaData.add("genre=" + String.valueOf((Object)bookInfo.genre()));
            }
            metaData.add("track=" + String.valueOf((Object)bookInfo.bookNumber()));
            if (!posters.isEmpty()) {
                FlacPicture picture = FlacPicture.load(posters.get(0).getFileName());
                metaData.add("metadata_block_picture=" + picture.write());
            }
            metaData.addAll(convertable.getMetaData(bookInfo));
            logger.debug("Saving metadata:" + String.join((CharSequence)"\n", metaData));
            FileUtils.writeLines((File)metaFile, (String)"UTF-8", metaData);
            return metaFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }
}

