/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.formats;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bramp.ffmpeg.progress.ProgressParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionException;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Convertable;
import uk.yermak.audiobookconverter.formats.Format;
import uk.yermak.audiobookconverter.formats.OutputParameters;

public class MP4Format
extends Format {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final List<Integer> FREQUENCIES = List.of(8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000, 88200, 96000);
    public static final List<Integer> BITRATES = List.of(8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, 192, 224, 256, 320);

    public MP4Format(String extension) {
        super("ipod", "aac", extension, "alac");
    }

    @Override
    public List<Integer> frequencies() {
        return FREQUENCIES;
    }

    @Override
    public List<Integer> bitrates() {
        return BITRATES;
    }

    @Override
    public Integer defaultBitrate() {
        return 128;
    }

    @Override
    public Double defaultSpeed() {
        return 1.0;
    }

    @Override
    public Integer defaultChannel() {
        return 2;
    }

    @Override
    public Integer defaultCutoff() {
        return 12000;
    }

    @Override
    public Integer defaultFrequency() {
        return 44100;
    }

    @Override
    public Integer defaultVbrQuality() {
        return 3;
    }

    @Override
    public Boolean defaultCBR() {
        return true;
    }

    @Override
    public boolean mp4Compatible() {
        return true;
    }

    @Override
    public boolean ffmpegCompatible() {
        return false;
    }

    @Override
    protected void setBitRateOptions(List<String> options, OutputParameters outputParameters) {
        options.addAll(outputParameters.cbr ? List.of("-b:a", outputParameters.getBitRate() + "k") : List.of("-q:a", String.valueOf(0.5 + (double)(outputParameters.vbrQuality * outputParameters.vbrQuality) * 0.06)));
    }

    @Override
    public List<String> getConcatOptions(String fileListFileName, String outputFileName, String progressUri, ConversionJob conversionJob) {
        String[] strings = new String[]{Platform.FFMPEG, "-protocol_whitelist", "file,pipe,concat", "-vn", "-f", "concat", "-safe", "0", "-i", fileListFileName, "-i", this.prepareMp4MetaFile(conversionJob), "-map_metadata", "1", "-f", this.name, "-c:a", "copy", "-progress", progressUri, outputFileName};
        return Arrays.asList(strings);
    }

    private String prepareMp4MetaFile(ConversionJob conversionJob) {
        AudioBookInfo bookInfo = conversionJob.getConversionGroup().getBookInfo();
        long jobId = conversionJob.getConversionGroup().getGroupId();
        Convertable convertable = conversionJob.getConvertable();
        try {
            File metaFile = new File(System.getProperty("java.io.tmpdir"), "FFMETADATAFILE" + jobId);
            metaFile.deleteOnExit();
            ArrayList<Object> metaData = new ArrayList<Object>();
            metaData.add(";FFMETADATA1");
            metaData.add("major_brand=M4A");
            metaData.add("minor_version=512");
            metaData.add("compatible_brands=isomiso2");
            metaData.add("title=" + String.valueOf((Object)bookInfo.title()) + (String)(convertable.isTheOnlyOne() ? "" : "-" + convertable.getNumber()));
            metaData.add("artist=" + String.valueOf((Object)bookInfo.writer()));
            if (StringUtils.isNotBlank((CharSequence)bookInfo.series().get())) {
                metaData.add("album=" + String.valueOf((Object)bookInfo.series()));
            } else {
                metaData.add("album=" + String.valueOf((Object)bookInfo.title()));
            }
            metaData.add("composer=" + String.valueOf((Object)bookInfo.narrator()));
            metaData.add("date=" + String.valueOf((Object)bookInfo.year()));
            metaData.add("comment=" + String.valueOf((Object)bookInfo.comment()));
            metaData.add("track=" + String.valueOf((Object)bookInfo.bookNumber()));
            metaData.add("media_type=2");
            metaData.add("genre=" + String.valueOf((Object)bookInfo.genre()));
            metaData.addAll(convertable.getMetaData(bookInfo));
            logger.debug("Saving metadata:" + String.join((CharSequence)"\n", metaData));
            FileUtils.writeLines((File)metaFile, (String)"UTF-8", metaData);
            return metaFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    public String[] getOptimizeOptions(String source, ProgressParser progressParser, String output, boolean hasPosters) {
        if (hasPosters) {
            return new String[]{Platform.FFMPEG, "-i", source, "-map", "0:v?", "-map", "0:a", "-c", "copy", "-f", this.name, "-progress", progressParser.getUri().toString(), "-movflags", "+faststart", output};
        }
        return new String[]{Platform.FFMPEG, "-i", source, "-c", "copy", "-f", this.name, "-progress", progressParser.getUri().toString(), "-movflags", "+faststart", output};
    }
}

