/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.formats;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionGroup;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Convertable;
import uk.yermak.audiobookconverter.formats.Format;
import uk.yermak.audiobookconverter.formats.OutputParameters;
import uk.yermak.audiobookconverter.fx.util.SmartStringProperty;

public class MP3Format
extends Format {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final List<Integer> CHANNELS = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(6));
    public static final List<Integer> FREQUENCIES = List.of(Integer.valueOf(8000), Integer.valueOf(11025), Integer.valueOf(16000), Integer.valueOf(22050), Integer.valueOf(24000), Integer.valueOf(32000), Integer.valueOf(44100), Integer.valueOf(48000));
    public static final List<Integer> BITRATES = List.of(32, 48, 64, 96, 112, 128, 160, 192, 224, 256, 320);

    MP3Format() {
        super("mp3", "libmp3lame", "mp3", new String[0]);
    }

    @Override
    public List<Integer> channels() {
        return CHANNELS;
    }

    @Override
    public List<Integer> frequencies() {
        return FREQUENCIES;
    }

    @Override
    public List<Integer> bitrates() {
        return BITRATES;
    }

    @Override
    public Double defaultSpeed() {
        return 1.0;
    }

    @Override
    public Integer defaultChannel() {
        return 2;
    }

    @Override
    public Integer defaultCutoff() {
        return 8000;
    }

    @Override
    public Boolean defaultCBR() {
        return true;
    }

    @Override
    public Integer defaultBitrate() {
        return 96;
    }

    @Override
    public Integer defaultFrequency() {
        return 22050;
    }

    @Override
    public Integer defaultVbrQuality() {
        return 3;
    }

    @Override
    public boolean mp4Compatible() {
        return false;
    }

    @Override
    public boolean ffmpegCompatible() {
        return false;
    }

    @Override
    protected void setBitRateOptions(List<String> options, OutputParameters outputParameters) {
        options.addAll(outputParameters.cbr ? List.of("-b:a", outputParameters.getBitRate() + "k") : List.of("-q:a", String.valueOf(10 - outputParameters.vbrQuality * 2)));
    }

    @Override
    public List<String> getConcatOptions(String fileListFileName, String outputFileName, String progressUri, ConversionJob conversionJob) {
        Convertable convertable = conversionJob.getConvertable();
        ConversionGroup conversionGroup = conversionJob.getConversionGroup();
        ArrayList<String> options = new ArrayList<String>();
        options.add(Platform.FFMPEG);
        options.add("-protocol_whitelist");
        options.add("file,pipe,concat");
        options.add("-f");
        options.add("concat");
        options.add("-safe");
        options.add("0");
        options.add("-i");
        options.add(fileListFileName);
        if (conversionGroup.getPosters().isEmpty()) {
            options.add("-vn");
        } else {
            options.add("-i");
            options.add(conversionGroup.getPosters().get(0).getFileName());
            options.add("-c:v");
            options.add("copy");
            options.add("-map");
            options.add("0:0");
            options.add("-map");
            options.add("1:0");
        }
        options.add("-c:a");
        options.add("copy");
        options.add("-id3v2_version");
        options.add("4");
        options.addAll(this.prepareId3v2Meta(convertable, conversionGroup.getBookInfo()));
        options.add("-f");
        options.add(this.name);
        options.add("-progress");
        options.add(progressUri);
        options.add(outputFileName);
        return options;
    }

    private List<String> prepareId3v2Meta(Convertable convertable, AudioBookInfo bookInfo) {
        ArrayList<String> meta = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)convertable.getDetails())) {
            meta.add("-metadata");
            meta.add("title=\"" + MP3Format.escapeQuotes(convertable.getDetails()) + "\"");
        }
        if (bookInfo.writer().isNotBlank()) {
            meta.add("-metadata");
            meta.add("artist=\"" + MP3Format.escapeQuotes(bookInfo.writer()) + "\"");
        }
        if (bookInfo.title().isNotBlank()) {
            meta.add("-metadata");
            meta.add("album=\"" + MP3Format.escapeQuotes(bookInfo.title()) + "\"");
        }
        if (bookInfo.genre().isNotBlank()) {
            meta.add("-metadata");
            meta.add("genre=\"" + MP3Format.escapeQuotes(bookInfo.genre()) + "\"");
        }
        if (bookInfo.narrator().isNotBlank()) {
            meta.add("-metadata");
            meta.add("composer=\"" + MP3Format.escapeQuotes(bookInfo.narrator()) + "\"");
        }
        if (bookInfo.year().isNotBlank()) {
            meta.add("-metadata");
            meta.add("year=\"" + MP3Format.escapeQuotes(bookInfo.year()) + "\"");
        }
        if (bookInfo.comment().isNotBlank()) {
            meta.add("-metadata");
            meta.add("comment=\"" + MP3Format.escapeQuotes(bookInfo.comment()) + "\"");
        }
        meta.add("-metadata");
        meta.add("track=\"" + convertable.getNumber() + "\"");
        return meta;
    }

    private static String escapeQuotes(String text) {
        return StringUtils.replace((String)text, (String)"\"", (String)"");
    }

    private static String escapeQuotes(SmartStringProperty text) {
        return MP3Format.escapeQuotes(text.getValueSafe());
    }
}

