/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.formats;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.formats.MP3Format;
import uk.yermak.audiobookconverter.formats.MP4Format;
import uk.yermak.audiobookconverter.formats.OGGFormat;
import uk.yermak.audiobookconverter.formats.OutputParameters;

public abstract class Format {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final List<Integer> CHANNELS = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6));
    public static final List<Integer> VBR_QUALITIES = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5));
    public static final List<Integer> CUT_OFFS = List.of(Integer.valueOf(4000), Integer.valueOf(6000), Integer.valueOf(8000), Integer.valueOf(12000), Integer.valueOf(20000));
    public static final List<Double> SPEEDS = List.of(0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0);
    protected String name;
    protected String codec;
    protected String extension;
    private final String[] compatibleCodecs;
    public static Format M4B = new MP4Format("m4b");
    public static Format M4A = new MP4Format("m4a");
    public static Format MP3 = new MP3Format();
    public static Format OGG = new OGGFormat();

    Format(String format, String codec, String extension, String ... compatibleCodecs) {
        this.name = format;
        this.codec = codec;
        this.extension = extension;
        this.compatibleCodecs = compatibleCodecs;
    }

    public static Format instance(String extension) {
        String ext;
        return switch (ext = extension.toLowerCase()) {
            case "m4b" -> M4B;
            case "m4a" -> M4A;
            case "mp3" -> MP3;
            case "ogg" -> OGG;
            default -> M4B;
        };
    }

    static String toFFMpegTime(long time) {
        return time / 1000L + "." + time % 1000L;
    }

    public List<Integer> channels() {
        return CHANNELS;
    }

    public List<Integer> vbrQualities() {
        return VBR_QUALITIES;
    }

    public List<Integer> cutoffs() {
        return CUT_OFFS;
    }

    public List<Double> speeds() {
        return SPEEDS;
    }

    public abstract List<Integer> frequencies();

    public abstract List<Integer> bitrates();

    public abstract Integer defaultBitrate();

    public abstract Double defaultSpeed();

    public abstract Integer defaultChannel();

    public abstract Integer defaultCutoff();

    public abstract Integer defaultFrequency();

    public abstract Boolean defaultCBR();

    public abstract List<String> getConcatOptions(String var1, String var2, String var3, ConversionJob var4);

    protected abstract void setBitRateOptions(List<String> var1, OutputParameters var2);

    public boolean needsReencode(String codec) {
        return !this.codec.equalsIgnoreCase(codec);
    }

    public String toString() {
        return this.extension;
    }

    public abstract boolean mp4Compatible();

    public abstract boolean ffmpegCompatible();

    public abstract Integer defaultVbrQuality();

    public boolean skipReedncode(String codec) {
        if (this.compatibleCodecs == null) {
            return false;
        }
        return ArrayUtils.contains((Object[])this.compatibleCodecs, (Object)codec);
    }

    public List<String> getTranscodingOptions(MediaInfo mediaInfo, String progressUri, String outputFileName) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(Platform.FFMPEG);
        if (mediaInfo.getOffset() != -1L) {
            options.add("-ss");
            options.add(Format.toFFMpegTime(mediaInfo.getOffset()));
        }
        options.add("-i");
        options.add(mediaInfo.getFileName());
        options.add("-map_metadata");
        options.add("-1");
        options.add("-map_chapters");
        options.add("-1");
        options.add("-vn");
        options.add("-codec:a");
        options.add("copy");
        if (mediaInfo.getOffset() != -1L) {
            options.add("-t");
            options.add(Format.toFFMpegTime(mediaInfo.getDuration()));
        }
        options.add("-f");
        options.add(this.name);
        options.add("-progress");
        options.add(progressUri);
        options.add(outputFileName);
        return options;
    }

    public List<String> getReencodingOptions(MediaInfo mediaInfo, String progressUri, String outputFileName, OutputParameters outputParameters) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(Platform.FFMPEG);
        if (mediaInfo.getOffset() != -1L) {
            options.add("-ss");
            options.add(Format.toFFMpegTime(mediaInfo.getOffset()));
        }
        options.add("-i");
        options.add(mediaInfo.getFileName());
        options.add("-vn");
        options.add("-codec:a");
        options.add(this.codec);
        options.add("-map_metadata");
        options.add("-1");
        this.setBitRateOptions(options, outputParameters);
        options.add("-ac");
        options.add(String.valueOf(outputParameters.getChannels()));
        options.add("-ar");
        options.add(String.valueOf(outputParameters.getFrequency()));
        if (mediaInfo.getOffset() != -1L) {
            options.add("-t");
            options.add(Format.toFFMpegTime(mediaInfo.getDuration()));
        }
        if (outputParameters.getCutoff() != null) {
            options.add("-cutoff");
            options.add(Integer.toString(outputParameters.getCutoff()));
        }
        options.add("-f");
        options.add(this.name);
        if (outputParameters.getSpeed() != 1.0) {
            options.add("-filter:a");
            options.add("atempo=" + outputParameters.getSpeed());
        }
        options.add("-progress");
        options.add(progressUri);
        options.add(outputFileName);
        return options;
    }
}

