/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.formats;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.Base64;
import javafx.scene.image.Image;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionException;

public record FlacPicture(int type, String description, String mime, int width, int height, int depth, byte[] data) {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static FlacPicture load(String artWorkFile) {
        try {
            FileInputStream inputstream = new FileInputStream(artWorkFile);
            Image image = new Image((InputStream)inputstream);
            String extension = FilenameUtils.getExtension((String)artWorkFile).toLowerCase();
            String mime = null;
            switch (extension) {
                case "png": {
                    mime = "image/png";
                    break;
                }
                case "jpg": 
                case "jfif": 
                case "jpeg": {
                    mime = "image/jpeg";
                    break;
                }
                default: {
                    logger.warn("Image format {} is not supported for OGG files", (Object)extension);
                }
            }
            return new FlacPicture(3, "Cover", mime, (int)image.getWidth(), (int)image.getHeight(), 24, FileUtils.readFileToByteArray((File)new File(artWorkFile)));
        }
        catch (IOException e) {
            logger.error("Failed to create FlacPicture from file", (Throwable)e);
            throw new ConversionException("Failed to create FlacPicture from file", e);
        }
    }

    public String write() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(ByteBuffer.allocate(4).putInt(this.type).array());
            byte[] mimeBytes = this.mime.getBytes();
            out.write(ByteBuffer.allocate(4).putInt(mimeBytes.length).array());
            out.write(mimeBytes);
            byte[] descBytes = this.description.getBytes();
            out.write(ByteBuffer.allocate(4).putInt(descBytes.length).array());
            out.write(descBytes);
            out.write(ByteBuffer.allocate(4).putInt(this.width).array());
            out.write(ByteBuffer.allocate(4).putInt(this.height).array());
            out.write(ByteBuffer.allocate(4).putInt(this.depth).array());
            int numberOfColors = 0;
            out.write(ByteBuffer.allocate(4).putInt(numberOfColors).array());
            out.write(ByteBuffer.allocate(4).putInt(this.data.length).array());
            out.write(this.data);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }
}

