/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.book;

import java.util.Collections;
import uk.yermak.audiobookconverter.book.Chapter;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.MediaTrackAdaptor;
import uk.yermak.audiobookconverter.book.Part;

public class Track {
    private long start;
    private long end;
    private String title;
    private String writer;
    private String trackNo;

    public Track(String trackNo) {
        this.trackNo = trackNo;
    }

    public Chapter toChapter(Part part, MediaInfo m) {
        MediaTrackAdaptor mediaTrackAdaptor = new MediaTrackAdaptor(m, this);
        Chapter chapter = new Chapter(part, Collections.singletonList(mediaTrackAdaptor));
        chapter.setCustomTitle(this.getTitle());
        chapter.getRenderMap().clear();
        chapter.getRenderMap().put("CUSTOM_TITLE", Chapter::getCustomTitle);
        mediaTrackAdaptor.setChapter(chapter);
        return chapter;
    }

    public String getTrackNo() {
        return this.trackNo;
    }

    public void setTrackNo(String trackNo) {
        this.trackNo = trackNo;
    }

    public void setStart(long startTime) {
        this.start = startTime;
    }

    public void setEnd(long endTime) {
        this.end = endTime;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setWriter(String writer) {
        this.writer = writer;
    }

    public String getWriter() {
        return this.writer;
    }

    public long getDuration() {
        return this.end - this.start;
    }
}

