/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.book;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Book;
import uk.yermak.audiobookconverter.book.Chapter;
import uk.yermak.audiobookconverter.book.Convertable;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.Organisable;
import uk.yermak.audiobookconverter.book.Track;

public class Part
implements Organisable,
Convertable {
    private final ObservableList<Chapter> chapters = FXCollections.observableArrayList();
    private final Book book;
    private final Map<String, Function<Part, Object>> renderMap = new HashMap<String, Function<Part, Object>>();

    public Part(Book book) {
        this.book = book;
        this.chapters.addListener((InvalidationListener)book);
        this.renderMap.put("BOOK_NUMBER", part -> part.getBook().getBookInfo().series().trimToNull());
        this.renderMap.put("SERIES", part -> part.getBook().getBookInfo().series().trimToNull());
        this.renderMap.put("TITLE", part -> part.getBook().getBookInfo().title().trimToNull());
        this.renderMap.put("WRITER", part -> part.getBook().getBookInfo().writer().trimToNull());
        this.renderMap.put("NARRATOR", part -> part.getBook().getBookInfo().narrator().trimToNull());
        this.renderMap.put("YEAR", part -> part.getBook().getBookInfo().year().trimToNull());
        this.renderMap.put("PART", Part::getNumber);
        this.renderMap.put("DURATION", p -> Duration.ofMillis(p.getDuration()));
    }

    public void replaceMediaChapterByTracksChapters(MediaInfo mediaInfo, List<Track> tracks) {
        List chapters = tracks.stream().map(t -> t.toChapter(this, mediaInfo)).collect(Collectors.toList());
        Chapter chapter = mediaInfo.getChapter();
        int position = this.getChapters().indexOf((Object)chapter);
        this.getChapters().addAll(position, chapters);
        mediaInfo.remove();
    }

    public void construct(ObservableList<Chapter> chapters) {
        chapters.forEach(c -> c.setPart(this));
        this.chapters.addAll(chapters);
    }

    @Override
    public String getTitle() {
        return "Part " + this.getNumber();
    }

    @Override
    public int getNumber() {
        return this.getBook().getParts().indexOf((Object)this) + 1;
    }

    @Override
    public int getTotalNumbers() {
        return this.getBook().getParts().size();
    }

    @Override
    public boolean isTheOnlyOne() {
        return this.book.getParts().size() == 1;
    }

    @Override
    public String getDetails() {
        return Utils.renderPart(this, this.renderMap);
    }

    @Override
    public long getDuration() {
        return this.chapters.stream().mapToLong(Chapter::getDuration).sum();
    }

    @Override
    public boolean split() {
        return false;
    }

    @Override
    public void remove() {
        this.getChapters().clear();
        this.book.getParts().remove((Object)this);
    }

    @Override
    public void moveUp() {
    }

    @Override
    public void moveDown() {
    }

    public ObservableList<Chapter> getChapters() {
        return this.chapters;
    }

    @Override
    public List<MediaInfo> getMedia() {
        return this.chapters.stream().flatMap(chapter -> chapter.getMedia().stream()).collect(Collectors.toList());
    }

    public Book getBook() {
        return this.book;
    }

    public void createNextPart(List<Chapter> chapters) {
        int i = this.book.getParts().indexOf((Object)this);
        Part part = new Part(this.book);
        part.construct((ObservableList<Chapter>)FXCollections.observableArrayList(chapters));
        this.book.getParts().add(i + 1, (Object)part);
    }

    public void combine(List<Part> mergers) {
        mergers.stream().flatMap(p -> p.getChapters().stream()).forEach(c -> {
            c.setPart(this);
            this.getChapters().add(c);
        });
        mergers.forEach(Part::remove);
    }

    @Override
    public List<String> getMetaData(AudioBookInfo bookInfo) {
        ArrayList<String> metaData = new ArrayList<String>();
        long totalDuration = 0L;
        for (Chapter chapter : this.getChapters()) {
            metaData.add("[CHAPTER]");
            metaData.add("TIMEBASE=1/1000");
            metaData.add("START=" + totalDuration);
            metaData.add("END=" + (totalDuration += chapter.getDuration()));
            metaData.add("title= " + Utils.renderChapter(chapter, chapter.getRenderMap()));
        }
        return metaData;
    }
}

