/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.book;

import java.util.List;
import java.util.Objects;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Chapter;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.MediaInfoOrganiser;
import uk.yermak.audiobookconverter.book.Track;

public class MediaTrackAdaptor
extends MediaInfoOrganiser
implements MediaInfo {
    private final MediaInfo mediaInfo;
    private final Track track;
    private long duration;

    public MediaTrackAdaptor(MediaInfo mediaInfo, Track track) {
        this.mediaInfo = mediaInfo;
        this.chapter = mediaInfo.getChapter();
        this.track = track;
        this.duration = track.getDuration();
    }

    @Override
    public String getTitle() {
        return this.track.getTrackNo();
    }

    @Override
    public String getDetails() {
        return this.track.getTitle();
    }

    @Override
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    public int getChannels() {
        return this.mediaInfo.getChannels();
    }

    @Override
    public int getFrequency() {
        return this.mediaInfo.getFrequency();
    }

    @Override
    public int getBitrate() {
        return this.mediaInfo.getBitrate();
    }

    @Override
    public long getDuration() {
        return (long)((double)this.duration / AudiobookConverter.getContext().getSpeed());
    }

    @Override
    public List<MediaInfo> getMedia() {
        return List.of(this.mediaInfo);
    }

    @Override
    public String getFileName() {
        return this.mediaInfo.getFileName();
    }

    @Override
    public AudioBookInfo getBookInfo() {
        return this.mediaInfo.getBookInfo();
    }

    @Override
    public String getCodec() {
        return this.mediaInfo.getCodec();
    }

    @Override
    public void setChapter(Chapter chapter) {
        this.chapter = chapter;
    }

    @Override
    public int getUID() {
        return Objects.hash(this.mediaInfo.getFileName(), this.track.getTrackNo());
    }

    @Override
    public String getReference() {
        return this.getFileName() + "-" + this.track.getTrackNo();
    }

    @Override
    public long getOffset() {
        return this.track.getStart();
    }

    @Override
    public int getTotalNumbers() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaInfo)) {
            return false;
        }
        MediaInfo that = (MediaInfo)o;
        return this.getReference().equals(that.getReference());
    }
}

