/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.book;

import java.util.ArrayList;
import java.util.Collections;
import uk.yermak.audiobookconverter.book.Chapter;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.Organisable;

public abstract class MediaInfoOrganiser
implements Organisable {
    protected Chapter chapter;

    @Override
    public boolean split() {
        if (this.chapter.getMedia().size() == 1) {
            return false;
        }
        if (this.getNumber() == 1) {
            return false;
        }
        ArrayList currentMedia = new ArrayList(this.chapter.getMedia().subList(0, this.getNumber() - 1));
        ArrayList<MediaInfo> nextMedia = new ArrayList<MediaInfo>(this.chapter.getMedia().subList(this.getNumber() - 1, this.chapter.getMedia().size()));
        this.chapter.getMedia().clear();
        this.chapter.getMedia().addAll(currentMedia);
        this.chapter.createNextChapter(nextMedia);
        return true;
    }

    @Override
    public void remove() {
        this.chapter.getMedia().remove((Object)this);
        if (this.chapter.getMedia().isEmpty()) {
            this.chapter.remove();
        }
    }

    @Override
    public void moveUp() {
        if (this.getNumber() < 2) {
            return;
        }
        Collections.swap(this.chapter.getMedia(), this.getNumber() - 1, this.getNumber() - 2);
    }

    @Override
    public void moveDown() {
        if (this.getNumber() >= this.chapter.getMedia().size()) {
            return;
        }
        Collections.swap(this.chapter.getMedia(), this.getNumber() - 1, this.getNumber());
    }

    @Override
    public int getNumber() {
        return this.chapter.getMedia().indexOf((Object)this) + 1;
    }

    @Override
    public int getTotalNumbers() {
        return this.getChapter().getMedia().size();
    }

    public void setChapter(Chapter chapter) {
        this.chapter = chapter;
    }

    public Chapter getChapter() {
        return this.chapter;
    }
}

