/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.book;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.MediaInfoOrganiser;

public class MediaInfoBean
extends MediaInfoOrganiser
implements MediaInfo {
    private final String fileName;
    private int channels;
    private int frequency;
    private int bitrate;
    private long duration;
    private AudioBookInfo bookInfo;
    private List<ArtWork> artWorks = new ArrayList<ArtWork>();
    private String codec;

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    @Override
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    public int getUID() {
        return Objects.hash(this.fileName);
    }

    @Override
    public String getReference() {
        return this.getFileName();
    }

    @Override
    public int getChannels() {
        return this.channels;
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    @Override
    public String getTitle() {
        return this.getBookInfo().title().get();
    }

    @Override
    public String getDetails() {
        return this.getFileName();
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public List<MediaInfo> getMedia() {
        return List.of(this);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setBookInfo(AudioBookInfo bookInfo) {
        this.bookInfo = bookInfo;
    }

    @Override
    public AudioBookInfo getBookInfo() {
        return this.bookInfo;
    }

    public void addArtWork(ArtWork artWork) {
        this.artWorks.add(artWork);
    }

    @Override
    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    @Override
    public long getOffset() {
        return -1L;
    }

    public MediaInfoBean(String fileName) {
        this.fileName = fileName;
        this.channels = 2;
        this.frequency = 44100;
        this.bitrate = 128000;
        this.duration = 0L;
        this.codec = "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaInfo)) {
            return false;
        }
        MediaInfo that = (MediaInfo)o;
        return this.getReference().equals(that.getReference());
    }
}

