/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.book;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.io.FilenameUtils;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Convertable;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.MediaTrackAdaptor;
import uk.yermak.audiobookconverter.book.Organisable;
import uk.yermak.audiobookconverter.book.Part;
import uk.yermak.audiobookconverter.book.Track;

public class Chapter
implements Organisable,
Convertable {
    private String customTitle;
    private final ObservableList<MediaInfo> media = FXCollections.observableArrayList();
    private Part part;
    private final Map<String, Function<Chapter, Object>> renderMap = new HashMap<String, Function<Chapter, Object>>();

    public Chapter(Part part, List<MediaInfo> media) {
        this.part = part;
        this.media.addListener((InvalidationListener)part.getBook());
        media.forEach(mediaInfo -> mediaInfo.setChapter(this));
        this.media.addAll(media);
        this.initRenderMap();
    }

    private void initRenderMap() {
        String[] contextArray = Settings.loadSetting().getChapterContext().split(":");
        HashSet<String> context = new HashSet<String>(Arrays.asList(contextArray));
        if (context.contains("CHAPTER_NUMBER")) {
            this.renderMap.put("CHAPTER_NUMBER", Chapter::getNumber);
        }
        if (context.contains("CHAPTER_TEXT")) {
            this.renderMap.put("CHAPTER_TEXT", c -> "Chapter");
        }
        if (context.contains("DURATION")) {
            this.renderMap.put("DURATION", c -> Duration.ofMillis(c.getDuration()));
        }
        if (context.contains("BOOK_NUMBER")) {
            this.renderMap.put("BOOK_NUMBER", c -> String.valueOf((Object)c.getPart().getBook().getBookInfo().bookNumber()));
        }
        if (context.contains("BOOK_TITLE")) {
            this.renderMap.put("BOOK_TITLE", c -> c.getPart().getBook().getBookInfo().title());
        }
        if (context.contains("TAG.1")) {
            this.renderMap.put("TAG.1", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().title());
        }
        if (context.contains("TAG.2")) {
            this.renderMap.put("TAG.2", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().writer());
        }
        if (context.contains("TAG.3")) {
            this.renderMap.put("TAG.3", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().narrator());
        }
        if (context.contains("TAG.4")) {
            this.renderMap.put("TAG.4", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().series());
        }
        if (context.contains("TAG.5")) {
            this.renderMap.put("TAG.5", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().genre());
        }
        if (context.contains("TAG.6")) {
            this.renderMap.put("TAG.6", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().year());
        }
        if (context.contains("TAG.7")) {
            this.renderMap.put("TAG.7", chapter -> ((MediaInfo)chapter.getMedia().get(0)).getBookInfo().comment());
        }
        if (context.contains("TAG.8")) {
            this.renderMap.put("TAG.8", chapter -> FilenameUtils.getBaseName((String)((MediaInfo)chapter.getMedia().get(0)).getFileName()));
        }
        if (context.contains("CUSTOM_TITLE")) {
            this.setCustomTitle(Settings.loadSetting().getChapterCustomTitle());
            this.renderMap.put("CUSTOM_TITLE", chapter -> this.customTitle);
        }
    }

    public void replaceMediaWithTracks(MediaInfo mediaInfo, List<Track> tracks) {
        List adaptors = tracks.stream().map(t -> new MediaTrackAdaptor(mediaInfo, (Track)t)).collect(Collectors.toList());
        int position = this.getMedia().indexOf((Object)mediaInfo);
        this.getMedia().remove(position);
        this.getMedia().addAll(position, adaptors);
    }

    public Chapter(MediaInfo mediaInfo) {
        this(null, Collections.singletonList(mediaInfo));
    }

    @Override
    public String getTitle() {
        return "Chapter " + this.getNumber();
    }

    @Override
    public int getNumber() {
        return this.part.getChapters().indexOf((Object)this) + 1;
    }

    @Override
    public int getTotalNumbers() {
        return this.part.getChapters().size();
    }

    @Override
    public boolean isTheOnlyOne() {
        return this.part.getChapters().size() == 1;
    }

    @Override
    public String getDetails() {
        return Utils.renderChapter(this, this.renderMap);
    }

    @Override
    public long getDuration() {
        return this.media.stream().mapToLong(Organisable::getDuration).sum();
    }

    @Override
    public boolean split() {
        if (this.part.getChapters().size() == 1) {
            return false;
        }
        if (this.getNumber() == 1) {
            return false;
        }
        ArrayList currentChapters = new ArrayList(this.part.getChapters().subList(0, this.getNumber() - 1));
        ArrayList<Chapter> nextChapters = new ArrayList<Chapter>(this.part.getChapters().subList(this.getNumber() - 1, this.part.getChapters().size()));
        this.part.getChapters().clear();
        this.part.getChapters().addAll(currentChapters);
        this.part.createNextPart(nextChapters);
        return true;
    }

    @Override
    public void remove() {
        this.getMedia().clear();
        this.part.getChapters().remove((Object)this);
        if (this.part.getChapters().isEmpty()) {
            this.part.remove();
        }
    }

    @Override
    public void moveUp() {
        if (this.getNumber() < 2) {
            return;
        }
        Collections.swap(this.part.getChapters(), this.getNumber() - 1, this.getNumber() - 2);
    }

    @Override
    public void moveDown() {
        if (this.getNumber() >= this.part.getChapters().size()) {
            return;
        }
        Collections.swap(this.part.getChapters(), this.getNumber() - 1, this.getNumber());
    }

    public ObservableList<MediaInfo> getMedia() {
        return this.media;
    }

    @Override
    public List<String> getMetaData(AudioBookInfo bookInfo) {
        ArrayList<String> metaData = new ArrayList<String>();
        metaData.add("[CHAPTER]");
        metaData.add("TIMEBASE=1/1000");
        metaData.add("START=0");
        metaData.add("END=" + this.getDuration());
        metaData.add("title= " + Utils.renderChapter(this, this.renderMap));
        return metaData;
    }

    public void setPart(Part part) {
        this.part = part;
        this.media.addListener((InvalidationListener)part.getBook());
    }

    public void createNextChapter(List<MediaInfo> nextMedia) {
        int i = this.part.getChapters().indexOf((Object)this);
        this.part.getChapters().add(i + 1, (Object)new Chapter(this.part, nextMedia));
    }

    public void combine(List<Chapter> mergers) {
        mergers.stream().flatMap(c -> c.getMedia().stream()).forEach(m -> {
            m.setChapter(this);
            this.getMedia().add(m);
        });
        mergers.forEach(Chapter::remove);
    }

    public Part getPart() {
        return this.part;
    }

    public Map<String, Function<Chapter, Object>> getRenderMap() {
        return this.renderMap;
    }

    public void setCustomTitle(String customTitle) {
        this.customTitle = customTitle;
    }

    public String getCustomTitle() {
        return this.customTitle;
    }
}

