/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.book;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Chapter;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.Organisable;
import uk.yermak.audiobookconverter.book.Part;
import uk.yermak.audiobookconverter.book.Track;

public class Book
implements Organisable,
InvalidationListener {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AudioBookInfo audioBookInfo;
    private final ObservableList<Part> parts = FXCollections.observableArrayList();
    private final List<InvalidationListener> listeners = new ArrayList<InvalidationListener>();

    public Book(AudioBookInfo audioBookInfo) {
        this.audioBookInfo = audioBookInfo;
    }

    public void construct(List<MediaInfo> items) {
        try {
            Part part = new Part(this);
            for (MediaInfo item : items) {
                if (item.getBookInfo().tracks().isEmpty()) {
                    Chapter chapter = new Chapter(part, Collections.singletonList(item));
                    part.getChapters().add((Object)chapter);
                    continue;
                }
                ObservableList<Track> tracks = item.getBookInfo().tracks();
                for (Track track : tracks) {
                    Chapter chapter = track.toChapter(part, item);
                    part.getChapters().add((Object)chapter);
                }
            }
            this.parts.add((Object)part);
        }
        catch (Throwable e) {
            logger.error("Error constructing book:", e);
        }
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getDetails() {
        return this.parts.size() + " Chapters";
    }

    @Override
    public long getDuration() {
        return this.parts.stream().mapToLong(Part::getDuration).sum();
    }

    @Override
    public boolean split() {
        return false;
    }

    @Override
    public void remove() {
    }

    @Override
    public void moveUp() {
    }

    @Override
    public void moveDown() {
    }

    public ObservableList<Part> getParts() {
        return this.parts;
    }

    public List<Chapter> getChapters() {
        return this.parts.stream().flatMap(part -> part.getChapters().stream()).collect(Collectors.toList());
    }

    @Override
    public List<MediaInfo> getMedia() {
        return this.parts.stream().flatMap(part -> part.getChapters().stream().flatMap(chapter -> chapter.getMedia().stream())).collect(Collectors.toList());
    }

    public AudioBookInfo getBookInfo() {
        return this.audioBookInfo;
    }

    public void invalidated(Observable observable) {
        ImmutableList list = ImmutableList.copyOf(this.listeners);
        list.forEach(invalidationListener -> invalidationListener.invalidated(observable));
    }

    public void addListener(InvalidationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public int getNumber() {
        return 1;
    }

    @Override
    public int getTotalNumbers() {
        return 1;
    }
}

