/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter.book;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.book.Track;
import uk.yermak.audiobookconverter.fx.util.SmartStringProperty;

public record AudioBookInfo(SmartStringProperty title, SmartStringProperty writer, SmartStringProperty narrator, SmartStringProperty series, SmartStringProperty genre, SmartStringProperty year, SmartStringProperty bookNumber, SmartStringProperty totalTracks, SmartStringProperty comment, ObservableList<Track> tracks) {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static AudioBookInfo instance(Map<String, String> tags) {
        long trackNumber = 0L;
        long trackCount = 0L;
        try {
            trackNumber = tags.get("track number") == null ? 0L : Long.parseLong(tags.get("track number"));
            trackCount = tags.get("track count") == null ? 0L : Long.parseLong(tags.get("track count"));
            String track = tags.get("track");
            if (StringUtils.isNotBlank((CharSequence)track)) {
                String[] split = track.split("/");
                if (split.length > 0 && StringUtils.isNumeric((CharSequence)split[0])) {
                    trackNumber = Long.parseLong(split[0]);
                }
                if (split.length > 1 && StringUtils.isNumeric((CharSequence)split[1])) {
                    trackCount = Long.parseLong(split[1]);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to parse track number:" + String.valueOf(e));
        }
        return new AudioBookInfo(new SmartStringProperty(StringUtils.trimToEmpty((String)tags.get("title"))), new SmartStringProperty(StringUtils.trimToEmpty((String)tags.get("artist"))), new SmartStringProperty((String)StringUtils.firstNonBlank((CharSequence[])new String[]{StringUtils.trimToEmpty((String)tags.get("narratedby")), StringUtils.trimToEmpty((String)tags.get("composer"))})), new SmartStringProperty(StringUtils.trimToEmpty((String)tags.get("album"))), new SmartStringProperty(StringUtils.trimToEmpty((String)tags.get("genre"))), new SmartStringProperty((String)StringUtils.firstNonBlank((CharSequence[])new String[]{StringUtils.trimToEmpty((String)tags.get("year")), StringUtils.substring((String)StringUtils.trimToEmpty((String)tags.get("date")), (int)0, (int)4)})), new SmartStringProperty(trackNumber == 0L ? "" : String.valueOf(trackNumber)), new SmartStringProperty(trackCount == 0L ? "" : String.valueOf(trackCount)), new SmartStringProperty((String)StringUtils.firstNonBlank((CharSequence[])new String[]{StringUtils.trimToEmpty((String)tags.get("comment")), StringUtils.trimToEmpty((String)tags.get("comment-0"))})), (ObservableList<Track>)FXCollections.observableArrayList());
    }

    public static AudioBookInfo instance() {
        return AudioBookInfo.instance(Collections.emptyMap());
    }
}

