/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.bramp.ffmpeg.progress.ProgressParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.NumberRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupString;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.Version;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Chapter;
import uk.yermak.audiobookconverter.book.Part;

public class Utils {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static String getTmp(long jobId, long fileId, String extension) {
        return new File(System.getProperty("java.io.tmpdir"), "~" + Version.getVersionString() + "_" + jobId + "_" + fileId + "." + extension).getAbsolutePath();
    }

    public static void closeSilently(ProgressParser progressParser) {
        if (progressParser != null) {
            try {
                progressParser.stop();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeSilently(Process process) {
        if (process != null) {
            process.destroyForcibly();
        }
    }

    public static String renderChapter(Chapter chapter, Map<String, Function<Chapter, Object>> context) {
        String chapterFormat = Settings.loadSetting().getChapterFormat();
        STGroupString g = new STGroupString("");
        g.registerRenderer(Number.class, (AttributeRenderer)new NumberRenderer());
        g.registerRenderer(Duration.class, (AttributeRenderer)new DurationRender());
        ST chapterTemplate = new ST((STGroup)g, chapterFormat);
        context.forEach((key, value) -> {
            if (key.contains("TAG")) {
                chapterTemplate.add("TAG", value.apply(chapter));
            } else {
                chapterTemplate.add(key, value.apply(chapter));
            }
        });
        return chapterTemplate.render();
    }

    public static String getOuputFilenameSuggestion(AudioBookInfo bookInfo) {
        char[] toRemove;
        String filenameFormat = Settings.loadSetting().getFilenameFormat();
        STGroupString g = new STGroupString("");
        g.registerRenderer(Number.class, (AttributeRenderer)new NumberRenderer());
        g.registerRenderer(Duration.class, (AttributeRenderer)new DurationRender());
        ST filenameTemplate = new ST((STGroup)g, filenameFormat);
        filenameTemplate.add("WRITER", (Object)bookInfo.writer().trimToNull());
        filenameTemplate.add("TITLE", (Object)bookInfo.title().trimToNull());
        filenameTemplate.add("SERIES", (Object)bookInfo.series().trimToNull());
        filenameTemplate.add("NARRATOR", (Object)bookInfo.narrator().trimToNull());
        filenameTemplate.add("BOOK_NUMBER", (Object)bookInfo.bookNumber().trimToNull());
        filenameTemplate.add("YEAR", (Object)bookInfo.year().trimToNull());
        String result = filenameTemplate.render();
        for (char c : toRemove = new char[]{':', '\\', '/', '>', '<', '|', '?', '*', '\"'}) {
            result = StringUtils.remove((String)result, (char)c);
        }
        String mp3Filename = StringUtils.isBlank((CharSequence)result) ? "NewBook" : result;
        return mp3Filename;
    }

    public static long checksumCRC32(File file) {
        try {
            return FileUtils.checksumCRC32((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String formatTime(double millis) {
        return Utils.formatTime((long)millis);
    }

    public static String formatTime(long millis) {
        return String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(millis) % TimeUnit.MINUTES.toSeconds(1L));
    }

    public static String formatSize(long bytes) {
        if (bytes == -1L) {
            return "---";
        }
        DecimalFormat mbFormat = new DecimalFormat("0");
        return mbFormat.format((double)bytes / 1048576.0) + " MB";
    }

    public static String tempCopy(String fileName) {
        File destFile = new File(Utils.getTmp(System.currentTimeMillis(), 0L, FilenameUtils.getExtension((String)fileName)));
        try {
            FileUtils.copyFile((File)new File(fileName), (File)destFile);
            return destFile.getPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String renderPart(Part part, Map<String, Function<Part, Object>> context) {
        char[] toRemove;
        String partFormat = Settings.loadSetting().getPartFormat();
        STGroupString g = new STGroupString("");
        g.registerRenderer(Number.class, (AttributeRenderer)new NumberRenderer());
        ST partTemplate = new ST((STGroup)g, partFormat);
        context.forEach((key, value) -> partTemplate.add(key, value.apply(part)));
        String result = partTemplate.render();
        for (char c : toRemove = new char[]{':', '\\', '/', '>', '<', '|', '?', '*', '\"'}) {
            result = StringUtils.remove((String)result, (char)c);
        }
        String mp3Filename = StringUtils.isBlank((CharSequence)result) ? "NewBook" : result;
        return mp3Filename;
    }

    public static String cleanText(String text) {
        return StringUtils.remove((String)StringUtils.trim((String)text), (char)'\"');
    }

    static String formatWithLeadingZeros(int size, int i) {
        int digits = (int)(Math.log10(size) + 1.0);
        return String.format("%0" + digits + "d", i);
    }

    public static String propertiesToString(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            stringBuilder.append(key).append(": ").append(value).append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    private static class DurationRender
    implements AttributeRenderer<Duration> {
        private DurationRender() {
        }

        public String toString(Duration duration, String format, Locale locale) {
            if (format == null) {
                format = "%02d:%02d:%02d";
            }
            return String.format(format, duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart());
        }
    }
}

