/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCopier
implements Callable<Long> {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private final InputStream in;
    private final OutputStream out;

    private StreamCopier(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public Long call() throws Exception {
        int n;
        long count = 0L;
        byte[] buffer = new byte[4096];
        while (-1 != (n = this.in.read(buffer))) {
            this.out.write(buffer, 0, n);
            count += (long)n;
        }
        StreamCopier.closeQuietly(this.in);
        StreamCopier.closeQuietly(this.out);
        return count;
    }

    public static Future<Long> copy(InputStream in, OutputStream out) {
        return executorService.submit(new StreamCopier(in, out));
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

