/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Platform {
    DEV{}
    ,
    MAC{

        @Override
        protected String getAppPath() {
            return "/";
        }

        @Override
        protected File getConfigFilePath() {
            return new File(this.getAppPath(), "Contents/app/path.properties");
        }
    }
    ,
    LINUX{

        @Override
        protected File getConfigFilePath() {
            return new File("../lib/app/path.properties");
        }
    }
    ,
    WINDOWS{

        @Override
        public Process createProcess(List<String> arguments) throws IOException {
            return Runtime.getRuntime().exec(String.join((CharSequence)" ", arguments));
        }
    };

    static Platform current;
    private static Properties properties;
    static final Logger logger;
    public static final String FFPROBE;
    public static final String MP4INFO;
    public static final String MP4ART;
    public static final String FFMPEG;

    private boolean isDebug() {
        String debug = System.getenv("DEBUG");
        return StringUtils.isNotEmpty((CharSequence)debug) && Boolean.parseBoolean(debug);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public boolean isLinux() {
        return System.getProperty("os.name").contains("Linux");
    }

    public boolean isMac() {
        return System.getProperty("os.name").contains("Mac OS X");
    }

    String getPath(String command) {
        return this.getAppPath() + properties.getProperty(command);
    }

    protected String getAppPath() {
        return "";
    }

    protected File getConfigFilePath() {
        return new File("app/path.properties");
    }

    synchronized Properties loadAppProperties() {
        if (properties.isEmpty()) {
            File file = this.getConfigFilePath();
            if (file.exists()) {
                try (FileInputStream in = new FileInputStream(file);){
                    properties.load(in);
                }
                catch (IOException e) {
                    logger.error("Error during loading properties", (Throwable)e);
                }
            } else {
                logger.error("Path properties is not found at: ", (Object)file.getPath());
            }
        }
        return properties;
    }

    public static File getInitialDirecotory(String sourceFolder) {
        if (sourceFolder == null) {
            return new File(System.getProperty("user.home"));
        }
        File file = new File(sourceFolder);
        return file.exists() ? file : Platform.getInitialDirecotory(file.getParent());
    }

    public Process createProcess(List<String> arguments) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(arguments);
        return pb.start();
    }

    static {
        properties = new Properties();
        if (LINUX.isLinux()) {
            current = LINUX;
        }
        if (MAC.isMac()) {
            current = MAC;
        }
        if (WINDOWS.isWindows()) {
            current = WINDOWS;
        }
        if (DEV.isDebug()) {
            current = DEV;
        }
        properties = current.loadAppProperties();
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        FFPROBE = current.getPath("ffprobe");
        MP4INFO = current.getPath("mp4info").replaceAll(" ", "\\ ");
        MP4ART = current.getPath("mp4art").replaceAll(" ", "\\ ");
        FFMPEG = current.getPath("ffmpeg").replaceAll(" ", "\\ ");
    }
}

