/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionException;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.ProgressCallback;
import uk.yermak.audiobookconverter.StreamCopier;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.ArtWork;

public class Mp4v2ArtBuilder {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConversionJob conversionJob;
    private ProgressCallback progressCallback;

    public Mp4v2ArtBuilder(ConversionJob conversionJob, ProgressCallback progressCallback) {
        this.conversionJob = conversionJob;
        this.progressCallback = progressCallback;
    }

    public void coverArt(String outputFileName) {
        List<ArtWork> posters = this.conversionJob.getConversionGroup().getPosters();
        if (posters.isEmpty()) {
            return;
        }
        this.progressCallback.reset();
        this.progressCallback.setState("Adding artwork...");
        long duration = this.conversionJob.getConvertable().getDuration();
        long step = duration / (long)posters.size();
        for (int i = 0; i < posters.size(); ++i) {
            ArtWork poster = posters.get(i);
            if (this.conversionJob.getStatus().isOver()) break;
            this.updateSinglePoster(poster, i, outputFileName);
            this.progressCallback.converted((long)(i + 1) * step, (long)posters.size() * step);
        }
    }

    public void updateSinglePoster(ArtWork poster, int index, String outputFileName) {
        Process process = null;
        try {
            ProcessBuilder artProcessBuilder = new ProcessBuilder(Platform.MP4ART, "--art-index", String.valueOf(index), "--add", poster.getFileName(), outputFileName);
            process = artProcessBuilder.start();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamCopier.copy(process.getInputStream(), out);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            StreamCopier.copy(process.getErrorStream(), err);
            boolean finished = false;
            while (!this.conversionJob.getStatus().isOver() && !finished) {
                finished = process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            logger.debug("mp4art out: {}", (Object)out);
            logger.warn("mp4art err: {}", (Object)err);
            if (process.exitValue() != 0) {
                throw new ConversionException("ArtWork failed with code " + process.exitValue() + "!=0", new Error(err.toString()));
            }
            if (!new File(outputFileName).exists()) {
                throw new ConversionException("ArtWork failed, no output file:" + String.valueOf(out), new Error(err.toString()));
            }
        }
        catch (Exception e) {
            try {
                logger.error("Failed to apply art work", (Throwable)e);
                throw new ConversionException("Failed to apply art work", e);
            }
            catch (Throwable throwable) {
                Utils.closeSilently(process);
                throw throwable;
            }
        }
        Utils.closeSilently(process);
    }
}

