/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import net.bramp.ffmpeg.progress.ProgressParser;
import net.bramp.ffmpeg.progress.TcpProgressParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionException;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.ProgressCallback;
import uk.yermak.audiobookconverter.ProgressStatus;
import uk.yermak.audiobookconverter.StreamCopier;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.formats.MP4Format;

public class FFMpegOptimizer {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConversionJob conversionJob;
    private String tempFile;
    private final String outputFileName;
    private ProgressCallback callback;
    private ProgressParser progressParser;

    public FFMpegOptimizer(ConversionJob conversionJob, String tempFile, String outputFileName, ProgressCallback callback) {
        this.conversionJob = conversionJob;
        this.tempFile = tempFile;
        this.outputFileName = outputFileName;
        this.callback = callback;
    }

    String optimize() throws InterruptedException, IOException {
        while (ProgressStatus.PAUSED.equals((Object)this.conversionJob.getStatus())) {
            Thread.sleep(1000L);
        }
        this.callback.reset();
        this.callback.setState("Optimising...");
        try {
            this.progressParser = new TcpProgressParser(progress -> this.callback.converted(progress.out_time_ns / 1000000L, progress.total_size));
            this.progressParser.start();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Process process = null;
        try {
            String optimizedFile = Utils.getTmp(this.conversionJob.getConversionGroup().getGroupId(), this.outputFileName.hashCode() + 1, this.conversionJob.getConversionGroup().getWorkfileExtension());
            if (this.conversionJob.getConversionGroup().getOutputParameters().getFormat().mp4Compatible()) {
                MP4Format format = (MP4Format)this.conversionJob.getConversionGroup().getOutputParameters().getFormat();
                boolean hasPosters = !this.conversionJob.getConversionGroup().getPosters().isEmpty();
                CharSequence[] optimize = format.getOptimizeOptions(this.tempFile, this.progressParser, optimizedFile, hasPosters);
                logger.debug("Starting optimisation with options {}", (Object)String.join((CharSequence)" ", optimize));
                ProcessBuilder pb = new ProcessBuilder((String[])optimize);
                process = pb.start();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                StreamCopier.copy(process.getInputStream(), out);
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                StreamCopier.copy(process.getErrorStream(), err);
                boolean finished = false;
                while (!this.conversionJob.getStatus().isOver() && !finished) {
                    finished = process.waitFor(500L, TimeUnit.MILLISECONDS);
                }
                logger.debug("Optimize Out: {}", (Object)out);
                logger.error("Optimize Error: {}", (Object)err);
                if (process.exitValue() != 0) {
                    throw new ConversionException("Optimisation exit code " + process.exitValue() + "!=0", new Error(err.toString()));
                }
                if (!new File(optimizedFile).exists()) {
                    throw new ConversionException("Optimisation failed, no output file:" + String.valueOf(out), new Error(err.toString()));
                }
            }
            String string = optimizedFile;
            return string;
        }
        catch (Exception e) {
            logger.error("Error during optimisation of resulting file:", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            Utils.closeSilently(process);
            Utils.closeSilently(this.progressParser);
        }
    }
}

