/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.ByteArrayOutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import net.bramp.ffmpeg.progress.ProgressParser;
import net.bramp.ffmpeg.progress.TcpProgressParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.DurationVerifier;
import uk.yermak.audiobookconverter.ProgressCallback;
import uk.yermak.audiobookconverter.ProgressStatus;
import uk.yermak.audiobookconverter.StreamCopier;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.formats.OutputParameters;

public class FFMpegNativeConverter
implements Callable<String> {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConversionJob conversionJob;
    private final MediaInfo mediaInfo;
    private final String outputFileName;
    private final ProgressCallback callback;
    private Process process;
    private ProgressParser progressParser = null;

    public FFMpegNativeConverter(ConversionJob conversionJob, MediaInfo mediaInfo, String outputFileName, ProgressCallback callback) {
        this.conversionJob = conversionJob;
        this.mediaInfo = mediaInfo;
        this.outputFileName = outputFileName;
        this.callback = callback;
    }

    @Override
    public String call() throws Exception {
        try {
            ProcessBuilder ffmpegProcessBuilder;
            if (this.conversionJob.getStatus().isOver()) {
                String string = null;
                return string;
            }
            while (ProgressStatus.PAUSED.equals((Object)this.conversionJob.getStatus())) {
                Thread.sleep(1000L);
            }
            this.progressParser = new TcpProgressParser(progress -> {
                this.callback.converted(progress.out_time_ns / 1000000L, progress.total_size);
                if (progress.isEnd()) {
                    this.callback.converted(progress.out_time_ns / 1000000L, progress.total_size);
                    this.callback.completedConversion();
                }
            });
            this.progressParser.start();
            OutputParameters outputParameters = this.conversionJob.getConversionGroup().getOutputParameters();
            if (outputParameters.needReencode(this.mediaInfo.getCodec())) {
                logger.debug("Re-encoding to {} for {}", (Object)outputParameters.getFormat(), (Object)this.outputFileName);
                ffmpegProcessBuilder = new ProcessBuilder(outputParameters.getFormat().getReencodingOptions(this.mediaInfo, this.progressParser.getUri().toString(), this.outputFileName, outputParameters));
            } else {
                logger.debug("Transcoding {} stream for {}", (Object)outputParameters.getFormat(), (Object)this.outputFileName);
                ffmpegProcessBuilder = new ProcessBuilder(outputParameters.getFormat().getTranscodingOptions(this.mediaInfo, this.progressParser.getUri().toString(), this.outputFileName));
            }
            this.process = ffmpegProcessBuilder.start();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamCopier.copy(this.process.getInputStream(), out);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            StreamCopier.copy(this.process.getErrorStream(), err);
            boolean finished = false;
            while (!this.conversionJob.getStatus().isOver() && !finished) {
                finished = this.process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            logger.debug("ffmpeg out: {}", (Object)out);
            logger.warn("ffmpeg err: {}", (Object)err);
            if (this.process.exitValue() != 0) {
                logger.error("Converstion failed: " + String.valueOf(err));
                throw new RuntimeException("Converstion failed: " + String.valueOf(err));
            }
            DurationVerifier.ffMpegUpdateDuration(this.mediaInfo, this.outputFileName);
            String string = this.outputFileName;
            return string;
        }
        catch (CancellationException ce) {
            String string = null;
            return string;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        finally {
            Utils.closeSilently(this.process);
            Utils.closeSilently(this.progressParser);
        }
    }
}

