/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.bramp.ffmpeg.progress.ProgressParser;
import net.bramp.ffmpeg.progress.TcpProgressParser;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.ConversionException;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.ProgressCallback;
import uk.yermak.audiobookconverter.ProgressStatus;
import uk.yermak.audiobookconverter.StreamCopier;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.formats.OutputParameters;

public class FFMpegConcatenator {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConversionJob conversionJob;
    private final String outputFileName;
    private List<MediaInfo> media;
    private final ProgressCallback callback;
    private ProgressParser progressParser;
    private List<String> tmpFiles = new ArrayList<String>();

    public FFMpegConcatenator(ConversionJob conversionJob, String outputFileName, List<MediaInfo> media, ProgressCallback callback) {
        this.conversionJob = conversionJob;
        this.outputFileName = outputFileName;
        this.media = media;
        this.callback = callback;
    }

    protected static File prepareFiles(long jobId, List<MediaInfo> media, String workfileExtension, String outputFileName) throws IOException {
        File fileListFile = new File(System.getProperty("java.io.tmpdir"), "filelist." + jobId + "_" + Objects.hash(outputFileName) + ".txt");
        List outFiles = media.stream().map(mediaInfo -> "file '" + Utils.getTmp(jobId, mediaInfo.getUID(), workfileExtension) + "'").collect(Collectors.toList());
        FileUtils.writeLines((File)fileListFile, (String)"UTF-8", outFiles);
        return fileListFile;
    }

    public void concat() throws IOException, InterruptedException {
        if (this.conversionJob.getStatus().isOver()) {
            return;
        }
        String fileListFileName = FFMpegConcatenator.prepareFiles(this.conversionJob.getConversionGroup().getGroupId(), this.media, this.conversionJob.getConversionGroup().getWorkfileExtension(), this.outputFileName).getAbsolutePath();
        while (ProgressStatus.PAUSED.equals((Object)this.conversionJob.getStatus())) {
            Thread.sleep(1000L);
        }
        this.callback.reset();
        try {
            this.progressParser = new TcpProgressParser(progress -> this.callback.converted(progress.out_time_ns / 1000000L, progress.total_size));
            this.progressParser.start();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Process process = null;
        try {
            OutputParameters outputParameters = this.conversionJob.getConversionGroup().getOutputParameters();
            List<String> concatOptions = outputParameters.getFormat().getConcatOptions(fileListFileName, this.outputFileName, this.progressParser.getUri().toString(), this.conversionJob);
            logger.info("Starting concat with options {}", (Object)String.join((CharSequence)" ", concatOptions));
            process = Platform.current.createProcess(concatOptions);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamCopier.copy(process.getInputStream(), out);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            StreamCopier.copy(process.getErrorStream(), err);
            boolean finished = false;
            while (!this.conversionJob.getStatus().isOver() && !finished) {
                finished = process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            logger.debug("Concat Out: {}", (Object)out);
            logger.error("Concat Error: {}", (Object)err);
            if (process.exitValue() != 0) {
                throw new ConversionException("Concatenation exit code " + process.exitValue() + "!=0", new Error(err.toString()));
            }
            if (!new File(this.outputFileName).exists()) {
                throw new ConversionException("Concatenation failed, no output file:" + String.valueOf(out), new Error(err.toString()));
            }
        }
        catch (Exception e) {
            try {
                logger.error("Error during concatination of files:", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Utils.closeSilently(process);
                Utils.closeSilently(this.progressParser);
                this.media.forEach(mediaInfo -> FileUtils.deleteQuietly((File)new File(Utils.getTmp(this.conversionJob.getConversionGroup().getGroupId(), mediaInfo.getUID(), this.conversionJob.getConversionGroup().getWorkfileExtension()))));
                FileUtils.deleteQuietly((File)new File(fileListFileName));
                throw throwable;
            }
        }
        Utils.closeSilently(process);
        Utils.closeSilently(this.progressParser);
        this.media.forEach(mediaInfo -> FileUtils.deleteQuietly((File)new File(Utils.getTmp(this.conversionJob.getConversionGroup().getGroupId(), mediaInfo.getUID(), this.conversionJob.getConversionGroup().getWorkfileExtension()))));
        FileUtils.deleteQuietly((File)new File(fileListFileName));
    }
}

