/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.List;
import net.bramp.ffmpeg.FFprobe;
import net.bramp.ffmpeg.probe.FFmpegProbeResult;
import net.bramp.ffmpeg.probe.FFmpegStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.StreamCopier;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.MediaInfo;

public class DurationVerifier {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    static long parseDuration(String info) {
        String[] lines;
        for (String line : lines = StringUtils.split((String)info, (String)"\n")) {
            String[] columns;
            if (!StringUtils.isNotEmpty((CharSequence)line) || !StringUtils.contains((CharSequence)(columns = StringUtils.split((String)line, (String)","))[0], (CharSequence)"audio")) continue;
            int columnsLength = columns.length;
            for (int j = 1; j < columnsLength; ++j) {
                String column = columns[j];
                int k = column.indexOf(" sec");
                if (k == -1) continue;
                String substring = column.substring(1, k);
                return (long)(Double.parseDouble(substring) * 1000.0);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mp4v2UpdateDuration(MediaInfo mediaInfo, String outputFileName) throws IOException {
        Process process = null;
        try {
            ProcessBuilder infoProcessBuilder = new ProcessBuilder(Platform.MP4INFO, outputFileName);
            process = infoProcessBuilder.start();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamCopier.copy(process.getInputStream(), (OutputStream)out);
            StreamCopier.copy(process.getErrorStream(), System.err);
            process.waitFor();
            String info = out.toString(Charset.defaultCharset());
            long duration = DurationVerifier.parseDuration(info);
            if (duration != 0L) {
                mediaInfo.setDuration(duration);
            } else {
                logger.warn("Failed to detect actual duration for '" + mediaInfo.getFileName() + "' in file: '" + outputFileName + "', extracted info: " + info);
            }
            Utils.closeSilently(process);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            Utils.closeSilently(process);
        }
    }

    public static void ffMpegUpdateDuration(MediaInfo mediaInfo, String outputFileName) throws IOException {
        ImmutableSet AUDIO_CODECS = ImmutableSet.of((Object)"mp3", (Object)"aac", (Object)"wmav2", (Object)"flac", (Object)"alac", (Object)"vorbis", (Object[])new String[]{"opus"});
        FFprobe ffprobe = new FFprobe(Platform.FFPROBE);
        FFmpegProbeResult probe = ffprobe.probe(outputFileName);
        List streams = probe.getStreams();
        for (FFmpegStream stream : streams) {
            if (!AUDIO_CODECS.contains(stream.codec_name)) continue;
            mediaInfo.setDuration(Math.round(stream.duration * 1000.0));
        }
    }
}

