/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.ConversionGroup;
import uk.yermak.audiobookconverter.FFMpegConcatenator;
import uk.yermak.audiobookconverter.FFMpegNativeConverter;
import uk.yermak.audiobookconverter.FFMpegOptimizer;
import uk.yermak.audiobookconverter.Mp4v2ArtBuilder;
import uk.yermak.audiobookconverter.ProgressCallback;
import uk.yermak.audiobookconverter.ProgressStatus;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.Convertable;
import uk.yermak.audiobookconverter.book.MediaInfo;

public class ConversionJob
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ExecutorService executorService = Executors.newWorkStealingPool();
    private final ConversionGroup conversionGroup;
    private final Convertable convertable;
    private final Map<String, ProgressCallback> progressCallbacks;
    private final String outputDestination;
    private final SimpleObjectProperty<ProgressStatus> status = new SimpleObjectProperty((Object)this, "status", (Object)ProgressStatus.READY);

    public ConversionJob(ConversionGroup conversionGroup, Convertable convertable, Map<String, ProgressCallback> progressCallbacks, String outputDestination) {
        this.conversionGroup = conversionGroup;
        this.convertable = convertable;
        this.progressCallbacks = progressCallbacks;
        this.outputDestination = outputDestination;
        this.addStatusChangeListener((ChangeListener<ProgressStatus>)((ChangeListener)(observable, oldValue, newValue) -> {
            if (ProgressStatus.FINISHED.equals(newValue)) {
                Platform.runLater(() -> AudiobookConverter.showNotification(outputDestination));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.status.set((Object)ProgressStatus.IN_PROGRESS);
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        String tempFile = Utils.getTmp(this.conversionGroup.getGroupId(), this.outputDestination.hashCode(), this.conversionGroup.getWorkfileExtension());
        try {
            List<MediaInfo> prioritizedMedia = this.prioritiseMedia();
            for (MediaInfo mediaInfo : prioritizedMedia) {
                String tempOutput = Utils.getTmp(this.conversionGroup.getGroupId(), mediaInfo.getUID(), this.conversionGroup.getWorkfileExtension());
                ProgressCallback callback = this.progressCallbacks.get(mediaInfo.getFileName() + "-" + mediaInfo.getDuration());
                Future<String> converterFuture = executorService.submit(new FFMpegNativeConverter(this, mediaInfo, tempOutput, callback));
                futures.add(converterFuture);
            }
            for (Future future : futures) {
                if (((ProgressStatus)((Object)this.status.get())).isOver()) {
                    return;
                }
                String outputFileName = (String)future.get();
                logger.debug("Waited for completion of {}", (Object)outputFileName);
            }
            if (((ProgressStatus)((Object)this.status.get())).isOver()) {
                return;
            }
            FFMpegConcatenator concatenator = new FFMpegConcatenator(this, tempFile, this.convertable.getMedia(), this.progressCallbacks.get("output"));
            concatenator.concat();
            if (((ProgressStatus)((Object)this.status.get())).isOver()) {
                return;
            }
            if (this.conversionGroup.getOutputParameters().getFormat().mp4Compatible()) {
                Mp4v2ArtBuilder mp4v2ArtBuilder = new Mp4v2ArtBuilder(this, this.progressCallbacks.get("output"));
                mp4v2ArtBuilder.coverArt(tempFile);
            }
            if (((ProgressStatus)((Object)this.status.get())).isOver()) {
                return;
            }
            File file = new File(this.outputDestination);
            if (this.getConversionGroup().getOutputParameters().getFormat().mp4Compatible()) {
                try {
                    String optimisedOutput = new FFMpegOptimizer(this, tempFile, this.outputDestination, this.progressCallbacks.get("output")).optimize();
                    if (file.exists()) {
                        FileUtils.deleteQuietly((File)file);
                    }
                    FileUtils.moveFile((File)new File(optimisedOutput), (File)file);
                }
                finally {
                    FileUtils.deleteQuietly((File)new File(tempFile));
                }
            } else {
                if (file.exists()) {
                    FileUtils.deleteQuietly((File)file);
                }
                FileUtils.moveFile((File)new File(tempFile), (File)file);
            }
            this.finished();
        }
        catch (Exception e) {
            logger.error("Error during parallel conversion", (Throwable)e);
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.error(e.getMessage() + "; " + sw.getBuffer().toString());
        }
    }

    private List<MediaInfo> prioritiseMedia() {
        return this.convertable.getMedia().stream().sorted((o1, o2) -> (int)(o2.getDuration() - o1.getDuration())).collect(Collectors.toList());
    }

    public void addStatusChangeListener(ChangeListener<ProgressStatus> listener) {
        this.status.addListener(listener);
    }

    public void pause() {
        if (((ProgressStatus)((Object)this.status.get())).equals((Object)ProgressStatus.IN_PROGRESS)) {
            this.status.set((Object)ProgressStatus.PAUSED);
        }
    }

    public void stop() {
        if (!((ProgressStatus)((Object)this.status.get())).equals((Object)ProgressStatus.FINISHED)) {
            this.status.set((Object)ProgressStatus.CANCELLED);
        }
    }

    public ProgressStatus getStatus() {
        return (ProgressStatus)((Object)this.status.get());
    }

    public void finished() {
        this.status.set((Object)ProgressStatus.FINISHED);
    }

    public void error(String message) {
        this.status.set((Object)ProgressStatus.ERROR);
    }

    public void resume() {
        if (((ProgressStatus)((Object)this.status.get())).equals((Object)ProgressStatus.PAUSED)) {
            this.status.set((Object)ProgressStatus.IN_PROGRESS);
        }
    }

    public ConversionGroup getConversionGroup() {
        return this.conversionGroup;
    }

    public String getOutputDestination() {
        return this.outputDestination;
    }

    public Convertable getConvertable() {
        return this.convertable;
    }
}

