/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.ListView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.AudiobookConverter;
import uk.yermak.audiobookconverter.ConversionJob;
import uk.yermak.audiobookconverter.ProgressCallback;
import uk.yermak.audiobookconverter.Utils;
import uk.yermak.audiobookconverter.book.ArtWork;
import uk.yermak.audiobookconverter.book.AudioBookInfo;
import uk.yermak.audiobookconverter.book.Book;
import uk.yermak.audiobookconverter.book.Chapter;
import uk.yermak.audiobookconverter.book.Convertable;
import uk.yermak.audiobookconverter.book.MediaInfo;
import uk.yermak.audiobookconverter.book.Part;
import uk.yermak.audiobookconverter.formats.Format;
import uk.yermak.audiobookconverter.formats.OutputParameters;
import uk.yermak.audiobookconverter.fx.ConversionProgress;
import uk.yermak.audiobookconverter.fx.ProgressComponent;

public class ConversionGroup {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<ConversionJob> jobs = new ArrayList<ConversionJob>();
    private boolean cancelled;
    private Book book;
    private AudioBookInfo bookInfo;
    private List<MediaInfo> media;
    private List<ArtWork> posters;
    private OutputParameters outputParameters;
    private boolean detached;
    private long groupId = System.currentTimeMillis();

    public ConversionProgress start(Convertable convertable, String outputDestination) {
        HashMap<String, ProgressCallback> progressCallbacks = new HashMap<String, ProgressCallback>();
        ConversionJob conversionJob = new ConversionJob(this, convertable, progressCallbacks, outputDestination);
        ConversionProgress conversionProgress = new ConversionProgress(conversionJob);
        progressCallbacks.put("output", new ProgressCallback("output", conversionProgress));
        convertable.getMedia().stream().map(m -> m.getFileName() + "-" + m.getDuration()).forEach(key -> progressCallbacks.put((String)key, new ProgressCallback((String)key, conversionProgress)));
        this.jobs.add(conversionJob);
        Executors.newSingleThreadExecutor().execute(conversionProgress);
        AudiobookConverter.getContext().addJob(conversionJob);
        return conversionProgress;
    }

    public OutputParameters getOutputParameters() {
        return this.outputParameters;
    }

    public AudioBookInfo getBookInfo() {
        return this.bookInfo;
    }

    public List<ArtWork> getPosters() {
        return this.posters;
    }

    public String getWorkfileExtension() {
        return this.outputParameters.getFormat().toString();
    }

    public boolean isOver() {
        if (this.cancelled) {
            return true;
        }
        if (this.jobs.isEmpty()) {
            return false;
        }
        for (ConversionJob job : this.jobs) {
            if (job.getStatus().isOver()) continue;
            return false;
        }
        return true;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public Book getBook() {
        return this.book;
    }

    public List<MediaInfo> getMedia() {
        return this.media;
    }

    public boolean isRunning() {
        for (ConversionJob job : this.jobs) {
            if (job.getStatus().isOver()) continue;
            return false;
        }
        return false;
    }

    public boolean isStarted() {
        for (ConversionJob job : this.jobs) {
            if (!job.getStatus().isStarted()) continue;
            return true;
        }
        return false;
    }

    public void setMedia(List<MediaInfo> media) {
        this.media = media;
    }

    public void setPosters(List<ArtWork> posters) {
        this.posters = posters;
    }

    public void setBook(Book book) {
        this.book = book;
    }

    public void setBookInfo(AudioBookInfo bookInfo) {
        this.bookInfo = bookInfo;
    }

    public void setOutputParameters(OutputParameters outputParameters) {
        this.outputParameters = outputParameters;
    }

    public void launch(ListView<ProgressComponent> progressQueue, ProgressComponent progressComponent, String outputDestination) {
        Book book = this.getBook();
        if (book == null) {
            book = new Book(this.getBookInfo());
            book.construct(this.getMedia());
        }
        ObservableList<Part> parts = book.getParts();
        Format format = this.getOutputParameters().getFormat();
        if (this.getOutputParameters().isSplitChapters()) {
            List chapters = parts.stream().flatMap(p -> p.getChapters().stream()).toList();
            logger.debug("Found {} chapters in the book", (Object)chapters.size());
            for (int i = 0; i < chapters.size(); ++i) {
                Chapter chapter = (Chapter)chapters.get(i);
                String finalDesination = outputDestination;
                if (chapters.size() > 1) {
                    finalDesination = finalDesination.replace("." + format.toString(), ", Chapter " + Utils.formatWithLeadingZeros(chapters.size(), i + 1) + "." + String.valueOf(format));
                }
                String finalName = new File(finalDesination).getName();
                logger.debug("Adding conversion for chapter {}", (Object)finalName);
                ConversionProgress conversionProgress = this.start(chapter, finalDesination);
                Platform.runLater(() -> progressQueue.getItems().add(0, (Object)new ProgressComponent(conversionProgress)));
            }
        } else {
            logger.debug("Found {} parts in the book", (Object)parts.size());
            for (int i = 0; i < parts.size(); ++i) {
                Part part = (Part)parts.get(i);
                String finalDesination = outputDestination;
                if (parts.size() > 1) {
                    finalDesination = finalDesination.replace("." + format.toString(), ", Part " + (i + 1) + "." + String.valueOf(format));
                }
                String finalName = new File(finalDesination).getName();
                logger.debug("Adding conversion for part {}", (Object)finalName);
                ConversionProgress conversionProgress = this.start(part, finalDesination);
                Platform.runLater(() -> progressQueue.getItems().add(0, (Object)new ProgressComponent(conversionProgress)));
            }
        }
        Platform.runLater(() -> progressQueue.getItems().remove((Object)progressComponent));
    }

    public void setDetached(boolean detached) {
        this.detached = detached;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public long getGroupId() {
        return this.groupId;
    }
}

