/*
 * Decompiled with CFR 0.152.
 */
package uk.yermak.audiobookconverter;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.concurrent.Executors;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.Notifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.yermak.audiobookconverter.Platform;
import uk.yermak.audiobookconverter.Settings;
import uk.yermak.audiobookconverter.Version;
import uk.yermak.audiobookconverter.fx.ConversionContext;
import uk.yermak.audiobookconverter.fx.JfxEnv;
import uk.yermak.audiobookconverter.fx.WizardDialog;

public class AudiobookConverter
extends Application {
    private static JfxEnv env;
    private static final ConversionContext context;
    static final Logger logger;

    public static void initAppHome() {
        File appDir;
        String appdata = System.getenv("APPDATA");
        if (appdata != null) {
            appDir = new File(appdata, Version.getVersionString());
        } else {
            File file = new File(".abc", Version.getVersionString());
            appDir = new File(System.getProperty("user.home"), file.getPath());
        }
        if (appDir.exists() || appDir.mkdirs()) {
            System.setProperty("APP_HOME", appDir.getAbsolutePath());
        } else {
            System.setProperty("APP_HOME", System.getProperty("user.home"));
        }
    }

    public static void main(String[] args) {
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        AudiobookConverter.launch((String[])args);
    }

    public static void checkNewVersion() {
        Executors.newSingleThreadExecutor().submit(new VersionChecker());
    }

    private ResourceBundle getBundleWithFallback(Locale locale) {
        ResourceBundle bundle = null;
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
        try {
            bundle = ResourceBundle.getBundle("locales/messages", locale, control);
        }
        catch (MissingResourceException e) {
            logger.error("Error getBundle", (Throwable)e);
        }
        return bundle != null ? bundle : ResourceBundle.getBundle("locales/messages", new Locale("en"), control);
    }

    public void start(Stage stage) {
        logger.info("Initialising application");
        Locale defaultLocale = Locale.getDefault();
        ResourceBundle bundle = this.getBundleWithFallback(defaultLocale);
        try {
            URL resource = AudiobookConverter.class.getResource("/uk/yermak/audiobookconverter/fx/fxml_converter.fxml");
            Parent root = (Parent)FXMLLoader.load((URL)resource, (ResourceBundle)bundle);
            Scene scene = new Scene(root);
            stage.setTitle("AudioBookConverter-" + Version.getVersionString());
            stage.setScene(scene);
            Screen primary = Screen.getPrimary();
            stage.setMinHeight(primary.getVisualBounds().getHeight() * 0.7);
            stage.setMinWidth(primary.getVisualBounds().getWidth() * 0.4);
            env = new JfxEnv(scene, this.getHostServices());
            Settings settings = Settings.loadSetting();
            boolean dark = settings.isDarkMode();
            if (dark) {
                env.setDarkMode(dark);
            }
            stage.show();
            stage.setOnCloseRequest(event -> {
                logger.info("Closing application");
                AudiobookConverter.getContext().stopConversions();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.exit(0);
            });
            AudiobookConverter.checkNewVersion();
            if (settings.isShowHints()) {
                AudiobookConverter.loadHints();
            }
        }
        catch (IOException e) {
            logger.error("Error initiating application", (Throwable)e);
            e.printStackTrace();
        }
    }

    public static void loadHints() throws IOException {
        List<String> hints = AudiobookConverter.readListFromURL("https://raw.githubusercontent.com/yermak/AudioBookConverter/version/hints.txt");
        if (!hints.isEmpty()) {
            Collections.shuffle(hints);
            WizardDialog wizardDialog = new WizardDialog(hints);
            wizardDialog.show();
        }
    }

    private static String readStringFromURL(String requestURL) throws IOException {
        try (Scanner scanner = new Scanner(new URL(requestURL).openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    public static ConversionContext getContext() {
        return context;
    }

    public static JfxEnv getEnv() {
        return env;
    }

    public static void showNotification(String finalOutputDestination) {
        Notifications.create().title("AudioBookConverter: Conversion is completed").text(finalOutputDestination).show();
    }

    private static List<String> readListFromURL(String requestURL) throws IOException {
        Scanner scanner = new Scanner(new URL(requestURL).openStream(), StandardCharsets.UTF_8.toString());
        try {
            scanner.useDelimiter("\\n");
            ArrayList<String> result = new ArrayList<String>();
            while (scanner.hasNext()) {
                result.add(scanner.next());
            }
            ArrayList<String> arrayList = result;
            scanner.close();
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error("Failed to read hints", (Throwable)e);
                return Collections.emptyList();
            }
        }
    }

    static {
        AudiobookConverter.initAppHome();
        context = new ConversionContext();
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    static class VersionChecker
    implements Runnable {
        VersionChecker() {
        }

        @Override
        public void run() {
            try {
                String platform = Platform.current.loadAppProperties().getProperty("platform");
                if (platform == null) {
                    platform = "version";
                }
                if ("steam".equals(platform)) {
                    return;
                }
                String version = AudiobookConverter.readStringFromURL("https://raw.githubusercontent.com/yermak/AudioBookConverter/version/" + platform + ".txt");
                if (!Version.getVersionString().equals(StringUtils.trim((String)version))) {
                    logger.info("New version found: {}", (Object)version);
                    javafx.application.Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("New Version Available!");
                        alert.setContentText("Would you like to download new version?");
                        Optional result = alert.showAndWait();
                        if (result.isPresent() && result.get() == ButtonType.OK) {
                            AudiobookConverter.getEnv().showDocument("https://store.steampowered.com/app/1529240/AudioBookConverter/");
                        }
                    });
                }
            }
            catch (IOException e) {
                logger.info(e.getMessage());
            }
        }
    }
}

