/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import org.modelmapper.internal.typetools.TypeResolver;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MappingContext;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;

class OptionalConverter
implements ConditionalConverter<Optional<?>, Optional<?>> {
    OptionalConverter() {
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Optional.class.equals(sourceType) && Optional.class.equals(destinationType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    @Override
    public Optional<?> convert(MappingContext<Optional<?>, Optional<?>> mappingContext) {
        Class<?> optionalType = this.getElementType(mappingContext);
        Optional<?> source = mappingContext.getSource();
        if (source == null) {
            return null;
        }
        if (source.isPresent()) {
            MappingContext<?, ?> optionalContext = mappingContext.create(source.get(), optionalType);
            return Optional.ofNullable(mappingContext.getMappingEngine().map(optionalContext));
        }
        return Optional.empty();
    }

    private Class<?> getElementType(MappingContext<Optional<?>, Optional<?>> mappingContext) {
        Mapping mapping = mappingContext.getMapping();
        if (mapping instanceof PropertyMapping) {
            PropertyInfo destInfo = mapping.getLastDestinationProperty();
            Class<?> elementType = TypeResolver.resolveRawArgument(destInfo.getGenericType(), destInfo.getInitialType());
            return elementType == TypeResolver.Unknown.class ? Object.class : elementType;
        }
        if (mappingContext.getGenericDestinationType() instanceof ParameterizedType) {
            return Types.rawTypeFor(((ParameterizedType)mappingContext.getGenericDestinationType()).getActualTypeArguments()[0]);
        }
        return Object.class;
    }
}

