/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.progress;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import net.bramp.ffmpeg.progress.AbstractSocketProgressParser;
import net.bramp.ffmpeg.progress.ProgressListener;
import net.bramp.ffmpeg.progress.UdpProgressParserRunnable;

public class UdpProgressParser
extends AbstractSocketProgressParser {
    final DatagramSocket socket;
    final URI address;

    public UdpProgressParser(ProgressListener listener) throws SocketException, URISyntaxException {
        this(listener, 0, InetAddress.getLoopbackAddress());
    }

    public UdpProgressParser(ProgressListener listener, int port, InetAddress addr) throws SocketException, URISyntaxException {
        super(listener);
        this.socket = new DatagramSocket(port, (InetAddress)Preconditions.checkNotNull((Object)addr));
        this.address = UdpProgressParser.createUri("udp", this.socket.getLocalAddress(), this.socket.getLocalPort());
        this.socket.setBroadcast(false);
    }

    @Override
    public synchronized void stop() throws IOException {
        if (this.socket.isClosed()) {
            return;
        }
        this.socket.close();
        super.stop();
    }

    @Override
    protected String getThreadName() {
        return "UdpProgressParser";
    }

    @Override
    protected Runnable getRunnable(CountDownLatch startSignal) {
        return new UdpProgressParserRunnable(this.parser, this.socket, startSignal);
    }

    @Override
    public URI getUri() {
        return this.address;
    }
}

