/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.probe;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bramp.ffmpeg.probe.FFmpegChapter;
import net.bramp.ffmpeg.probe.FFmpegError;
import net.bramp.ffmpeg.probe.FFmpegFormat;
import net.bramp.ffmpeg.probe.FFmpegFrame;
import net.bramp.ffmpeg.probe.FFmpegFrameOrPacket;
import net.bramp.ffmpeg.probe.FFmpegPacket;
import net.bramp.ffmpeg.probe.FFmpegStream;

@SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="POJO objects where the fields are populated by gson")
public class FFmpegProbeResult {
    public FFmpegError error;
    public FFmpegFormat format;
    public List<FFmpegStream> streams;
    public List<FFmpegChapter> chapters;
    private List<FFmpegPacket> packets;
    private List<FFmpegFrame> frames;
    public List<FFmpegFrameOrPacket> packets_and_frames;

    public FFmpegError getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public FFmpegFormat getFormat() {
        return this.format;
    }

    public List<FFmpegStream> getStreams() {
        if (this.streams == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.streams);
    }

    public List<FFmpegChapter> getChapters() {
        if (this.chapters == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.chapters);
    }

    public List<FFmpegPacket> getPackets() {
        if (this.packets == null) {
            if (this.packets_and_frames != null) {
                ArrayList<FFmpegPacket> tmp = new ArrayList<FFmpegPacket>();
                for (FFmpegFrameOrPacket packetsAndFrame : this.packets_and_frames) {
                    if (!(packetsAndFrame instanceof FFmpegPacket)) continue;
                    tmp.add((FFmpegPacket)packetsAndFrame);
                }
                this.packets = tmp;
            } else {
                return Collections.emptyList();
            }
        }
        return ImmutableList.copyOf(this.packets);
    }

    public List<FFmpegFrame> getFrames() {
        if (this.frames == null) {
            if (this.packets_and_frames != null) {
                ArrayList<FFmpegFrame> tmp = new ArrayList<FFmpegFrame>();
                for (FFmpegFrameOrPacket packetsAndFrame : this.packets_and_frames) {
                    if (!(packetsAndFrame instanceof FFmpegFrame)) continue;
                    tmp.add((FFmpegFrame)packetsAndFrame);
                }
                this.frames = tmp;
            } else {
                return Collections.emptyList();
            }
        }
        return ImmutableList.copyOf(this.frames);
    }
}

