/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.nut;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.bramp.ffmpeg.nut.NutDataInputStream;
import net.bramp.ffmpeg.nut.Packet;
import org.apache.commons.lang3.math.Fraction;

public class StreamHeaderPacket
extends Packet {
    public static final int VIDEO = 0;
    public static final int AUDIO = 1;
    public static final int SUBTITLE = 2;
    public static final int USER_DATA = 3;
    int id;
    long type;
    byte[] fourcc;
    int timeBaseId;
    int msbPtsShift;
    int maxPtsDistance;
    long decodeDelay;
    long flags;
    byte[] codecSpecificData;
    int width;
    int height;
    int sampleWidth;
    int sampleHeight;
    long colorspaceType;
    Fraction sampleRate = Fraction.ZERO;
    int channels;

    protected static String fourccToString(byte[] fourcc) {
        return new String(fourcc, StandardCharsets.ISO_8859_1);
    }

    @Override
    protected void readBody(NutDataInputStream in) throws IOException {
        this.id = in.readVarInt();
        this.type = in.readVarLong();
        this.fourcc = in.readVarArray();
        if (this.fourcc.length != 2 && this.fourcc.length != 4) {
            throw new IOException("Unexpected fourcc length: " + this.fourcc.length);
        }
        this.timeBaseId = in.readVarInt();
        this.msbPtsShift = in.readVarInt();
        if (this.msbPtsShift >= 16) {
            throw new IOException("invalid msbPtsShift " + this.msbPtsShift + " want < 16");
        }
        this.maxPtsDistance = in.readVarInt();
        this.decodeDelay = in.readVarLong();
        this.flags = in.readVarLong();
        this.codecSpecificData = in.readVarArray();
        if (this.type == 0L) {
            this.width = in.readVarInt();
            this.height = in.readVarInt();
            if (this.width == 0 || this.height == 0) {
                throw new IOException("invalid video dimensions " + this.width + "x" + this.height);
            }
            this.sampleWidth = in.readVarInt();
            this.sampleHeight = in.readVarInt();
            if ((this.sampleWidth == 0 || this.sampleHeight == 0) && this.sampleWidth != this.sampleHeight) {
                throw new IOException("invalid video sample dimensions " + this.sampleWidth + "x" + this.sampleHeight);
            }
            this.colorspaceType = in.readVarLong();
        } else if (this.type == 1L) {
            int samplerateNum = in.readVarInt();
            int samplerateDenom = in.readVarInt();
            this.sampleRate = Fraction.getFraction((int)samplerateNum, (int)samplerateDenom);
            this.channels = in.readVarInt();
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("id", this.id).add("type", this.type).add("fourcc", (Object)StreamHeaderPacket.fourccToString(this.fourcc)).add("timeBaseId", this.timeBaseId).add("msbPtsShift", this.msbPtsShift).add("maxPtsDistance", this.maxPtsDistance).add("decodeDelay", this.decodeDelay).add("flags", this.flags).add("codecSpecificData", (Object)this.codecSpecificData).add("width", this.width).add("height", this.height).add("sampleWidth", this.sampleWidth).add("sampleHeight", this.sampleHeight).add("colorspaceType", this.colorspaceType).add("sampleRate", (Object)this.sampleRate).add("channels", this.channels).add("footer", (Object)this.footer).toString();
    }
}

