/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.nut;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.bramp.ffmpeg.nut.FrameCode;
import net.bramp.ffmpeg.nut.NutDataInputStream;
import net.bramp.ffmpeg.nut.Packet;
import org.apache.commons.lang3.math.Fraction;

public class MainHeaderPacket
extends Packet {
    public static final int BROADCAST_MODE = 0;
    long version;
    long minorVersion;
    int streamCount;
    long maxDistance;
    Fraction[] timeBase;
    long flags;
    final List<FrameCode> frameCodes = new ArrayList<FrameCode>();
    final List<byte[]> elision = new ArrayList<byte[]>();

    @Override
    protected void readBody(NutDataInputStream in) throws IOException {
        this.frameCodes.clear();
        this.version = in.readVarLong();
        if (this.version > 3L) {
            this.minorVersion = in.readVarLong();
        }
        this.streamCount = in.readVarInt();
        if (this.streamCount >= 250) {
            throw new IOException("Illegal stream count " + this.streamCount + " must be < 250");
        }
        this.maxDistance = in.readVarLong();
        if (this.maxDistance > 65536L) {
            this.maxDistance = 65536L;
        }
        int time_base_count = in.readVarInt();
        this.timeBase = new Fraction[time_base_count];
        for (int i = 0; i < time_base_count; ++i) {
            int time_base_num = (int)in.readVarLong();
            int time_base_denom = (int)in.readVarLong();
            this.timeBase[i] = Fraction.getFraction((int)time_base_num, (int)time_base_denom);
        }
        long pts = 0L;
        int mul = 1;
        int stream_id = 0;
        int header_idx = 0;
        long match = -4611686018427387903L;
        int i = 0;
        while (i < 256) {
            int reserved;
            long flags = in.readVarLong();
            long fields = in.readVarLong();
            if (fields > 0L) {
                pts = in.readSignedVarInt();
            }
            if (fields > 1L && (mul = in.readVarInt()) >= 16384) {
                throw new IOException("Illegal mul value " + mul + " must be < 16384");
            }
            if (fields > 2L && (stream_id = in.readVarInt()) >= this.streamCount) {
                throw new IOException("Illegal stream id value " + stream_id + " must be < " + this.streamCount);
            }
            int size = fields > 3L ? in.readVarInt() : 0;
            if (fields > 4L) {
                reserved = in.readVarInt();
                if (reserved >= 256) {
                    throw new IOException("Illegal reserved frame count " + reserved + " must be < 256");
                }
            } else {
                reserved = 0;
            }
            long count = fields > 5L ? in.readVarLong() : (long)mul - (long)size;
            if (fields > 6L) {
                match = in.readSignedVarInt();
            }
            if (fields > 7L) {
                header_idx = in.readVarInt();
            }
            int j = 8;
            while ((long)j < fields) {
                in.readVarLong();
                ++j;
            }
            if (stream_id >= this.streamCount) {
                throw new IOException(String.format("Invalid stream value %d, must be < %d", stream_id, this.streamCount));
            }
            if (count <= 0L || count > (long)(256 - i - (i <= 78 ? 1 : 0))) {
                throw new IOException(String.format("Invalid count value %d, must be > 0 && < %d", count, 256 - i - (i <= 78 ? 1 : 0)));
            }
            j = 0;
            while ((long)j < count && i < 256) {
                FrameCode fc = new FrameCode();
                this.frameCodes.add(fc);
                if (i == 78) {
                    fc.flags = 8192L;
                    --j;
                } else {
                    fc.flags = flags;
                    fc.streamId = stream_id;
                    fc.dataSizeMul = mul;
                    fc.dataSizeLsb = size + j;
                    fc.ptsDelta = pts;
                    fc.reservedCount = reserved;
                    fc.matchTimeDelta = match;
                    fc.headerIdx = header_idx;
                    if (fc.dataSizeLsb >= 16384) {
                        throw new IOException("Illegal dataSizeLsb value " + fc.dataSizeLsb + " must be < 16384");
                    }
                }
                ++j;
                ++i;
            }
        }
        int remain = 1024;
        if (in.offset() < this.header.end - 4L) {
            int header_count = in.readVarInt();
            if (header_count >= 128) {
                throw new IOException("Invalid header_count value " + header_count + " must be < 128");
            }
            this.elision.clear();
            this.elision.add(new byte[0]);
            for (int i2 = 1; i2 < header_count; ++i2) {
                byte[] e = in.readVarArray();
                if (e.length == 0 || e.length >= 256) {
                    throw new IOException("Invalid elision length " + e.length + " must be > 0 and < 256");
                }
                if (e.length > remain) {
                    throw new IOException("Invalid elision length value " + e.length + " must be <= " + remain);
                }
                remain -= e.length;
                this.elision.add(e);
            }
        }
        if (this.version > 3L && in.offset() < this.header.end - 4L) {
            this.flags = in.readVarLong();
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("version", this.version).add("minorVersion", this.minorVersion).add("streamCount", this.streamCount).add("maxDistance", this.maxDistance).add("timeBase", (Object)this.timeBase).add("flags", this.flags).add("frameCodes", this.frameCodes.size()).add("elision", this.elision).add("footer", (Object)this.footer).toString();
    }
}

