/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.info;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.bramp.ffmpeg.info.ChannelLayout;
import net.bramp.ffmpeg.info.IndividualChannel;
import net.bramp.ffmpeg.info.StandardChannelLayout;

public final class InfoParser {
    private InfoParser() {
        throw new AssertionError((Object)"No instances for you!");
    }

    public static List<ChannelLayout> parseLayouts(BufferedReader r) throws IOException {
        String line;
        HashMap<String, IndividualChannel> individualChannelLookup = new HashMap<String, IndividualChannel>();
        ArrayList<ChannelLayout> channelLayouts = new ArrayList<ChannelLayout>();
        boolean parsingIndividualChannels = false;
        boolean parsingChannelLayouts = false;
        while ((line = r.readLine()) != null) {
            String[] s;
            if (line.startsWith("NAME") || line.isEmpty()) continue;
            if (line.equals("Individual channels:")) {
                parsingIndividualChannels = true;
                parsingChannelLayouts = false;
                continue;
            }
            if (line.equals("Standard channel layouts:")) {
                parsingIndividualChannels = false;
                parsingChannelLayouts = true;
                continue;
            }
            if (parsingIndividualChannels) {
                s = line.split(" ", 2);
                IndividualChannel individualChannel = new IndividualChannel(s[0], s[1].trim());
                channelLayouts.add(individualChannel);
                individualChannelLookup.put(individualChannel.getName(), individualChannel);
                continue;
            }
            if (!parsingChannelLayouts) continue;
            s = line.split(" ", 2);
            ArrayList<IndividualChannel> decomposition = new ArrayList<IndividualChannel>();
            for (String channelName : Splitter.on((char)'+').split((CharSequence)s[1].trim())) {
                decomposition.add((IndividualChannel)individualChannelLookup.get(channelName));
            }
            channelLayouts.add(new StandardChannelLayout(s[0], Collections.unmodifiableList(decomposition)));
        }
        return channelLayouts;
    }
}

