/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.info;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class Format {
    private final String name;
    private final String longName;
    private final boolean canDemux;
    private final boolean canMux;

    public Format(String name, String longName, String flags) {
        this.name = ((String)Preconditions.checkNotNull((Object)name)).trim();
        this.longName = ((String)Preconditions.checkNotNull((Object)longName)).trim();
        Preconditions.checkNotNull((Object)flags);
        Preconditions.checkArgument((flags.length() == 2 ? 1 : 0) != 0, (String)"Format flags is invalid '%s'", (Object)flags);
        this.canDemux = flags.charAt(0) == 'D';
        this.canMux = flags.charAt(1) == 'E';
    }

    public String toString() {
        return this.name + " " + this.longName;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public boolean getCanDemux() {
        return this.canDemux;
    }

    public boolean getCanMux() {
        return this.canMux;
    }
}

