/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.bramp.ffmpeg.shared.CodecType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FilterPattern {
    private final boolean sinkOrSource;
    private final boolean variableStreams;
    private final List<CodecType> streams;

    public FilterPattern(String pattern) {
        this.sinkOrSource = pattern.contains("|");
        this.variableStreams = pattern.contains("N");
        ArrayList<CodecType> streams = new ArrayList<CodecType>();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '|' || c == 'N') continue;
            if (c == 'A') {
                streams.add(CodecType.AUDIO);
                continue;
            }
            if (c == 'V') {
                streams.add(CodecType.VIDEO);
                continue;
            }
            throw new IllegalStateException("Unsupported character in filter pattern " + c);
        }
        this.streams = Collections.unmodifiableList(streams);
    }

    public boolean isSinkOrSource() {
        return this.sinkOrSource;
    }

    public boolean isVariableStreams() {
        return this.variableStreams;
    }

    public List<CodecType> getStreams() {
        return this.streams;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        if (this.isSinkOrSource()) {
            return "|";
        }
        if (this.isVariableStreams()) {
            return "N";
        }
        return Arrays.toString(this.streams.toArray());
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }
}

