/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.info;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import net.bramp.ffmpeg.shared.CodecType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class Codec {
    private final String name;
    private final String longName;
    private final boolean canDecode;
    private final boolean canEncode;
    private final CodecType type;
    final boolean intraFrameOnly;
    final boolean lossyCompression;
    final boolean losslessCompression;

    public Codec(String name, String longName, String flags) {
        this.name = ((String)Preconditions.checkNotNull((Object)name)).trim();
        this.longName = ((String)Preconditions.checkNotNull((Object)longName)).trim();
        Preconditions.checkNotNull((Object)flags);
        Preconditions.checkArgument((flags.length() == 6 ? 1 : 0) != 0, (String)"Codec flags is invalid '%s'", (Object)flags);
        switch (flags.charAt(0)) {
            case 'D': {
                this.canDecode = true;
                break;
            }
            case '.': {
                this.canDecode = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid decoding value '" + flags.charAt(0) + "'");
            }
        }
        switch (flags.charAt(1)) {
            case 'E': {
                this.canEncode = true;
                break;
            }
            case '.': {
                this.canEncode = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid encoding value '" + flags.charAt(1) + "'");
            }
        }
        switch (flags.charAt(2)) {
            case 'V': {
                this.type = CodecType.VIDEO;
                break;
            }
            case 'A': {
                this.type = CodecType.AUDIO;
                break;
            }
            case 'S': {
                this.type = CodecType.SUBTITLE;
                break;
            }
            case 'D': {
                this.type = CodecType.DATA;
                break;
            }
            case 'T': {
                this.type = CodecType.ATTACHMENT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid codec type '" + flags.charAt(2) + "'");
            }
        }
        switch (flags.charAt(3)) {
            case 'I': {
                this.intraFrameOnly = true;
                break;
            }
            case '.': {
                this.intraFrameOnly = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid encoding value '" + flags.charAt(3) + "'");
            }
        }
        switch (flags.charAt(4)) {
            case 'L': {
                this.lossyCompression = true;
                break;
            }
            case '.': {
                this.lossyCompression = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid lossy compression value '" + flags.charAt(4) + "'");
            }
        }
        switch (flags.charAt(5)) {
            case 'S': {
                this.losslessCompression = true;
                break;
            }
            case '.': {
                this.losslessCompression = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid lossless compression value '" + flags.charAt(5) + "'");
            }
        }
    }

    public String toString() {
        return this.name + " " + this.longName;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public boolean getCanDecode() {
        return this.canDecode;
    }

    public boolean getCanEncode() {
        return this.canEncode;
    }

    public CodecType getType() {
        return this.type;
    }

    public boolean isIntraFrameOnly() {
        return this.intraFrameOnly;
    }

    public boolean supportsLossyCompression() {
        return this.lossyCompression;
    }

    public boolean supportsLosslessCompression() {
        return this.losslessCompression;
    }
}

