/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.builder;

import com.google.common.base.Preconditions;
import net.bramp.ffmpeg.builder.MetadataSpecifier;
import net.bramp.ffmpeg.builder.StreamSpecifierType;

public class StreamSpecifier {
    private final String spec;

    private StreamSpecifier(String spec) {
        this.spec = spec;
    }

    public String spec() {
        return this.spec;
    }

    public static StreamSpecifier stream(int index) {
        return new StreamSpecifier(String.valueOf(index));
    }

    public static StreamSpecifier stream(StreamSpecifierType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        return new StreamSpecifier(type.toString());
    }

    public static StreamSpecifier stream(StreamSpecifierType type, int index) {
        Preconditions.checkNotNull((Object)((Object)type));
        return new StreamSpecifier(type.toString() + ":" + index);
    }

    public static StreamSpecifier program(int program_id) {
        return new StreamSpecifier("p:" + program_id);
    }

    public static StreamSpecifier program(int program_id, int stream_index) {
        return new StreamSpecifier("p:" + program_id + ":" + stream_index);
    }

    public static StreamSpecifier id(int stream_id) {
        return new StreamSpecifier("i:" + stream_id);
    }

    public static StreamSpecifier tag(String key) {
        return new StreamSpecifier("m:" + MetadataSpecifier.checkValidKey(key));
    }

    public static StreamSpecifier tag(String key, String value) {
        MetadataSpecifier.checkValidKey(key);
        Preconditions.checkNotNull((Object)value);
        return new StreamSpecifier("m:" + key + ":" + value);
    }

    public static StreamSpecifier usable() {
        return new StreamSpecifier("u");
    }
}

