/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.builder;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import net.bramp.ffmpeg.builder.StreamSpecifier;
import net.bramp.ffmpeg.builder.StreamSpecifierType;

@Immutable
public class MetadataSpecifier {
    private final String spec;

    private MetadataSpecifier(String spec) {
        this.spec = (String)Preconditions.checkNotNull((Object)spec);
    }

    private MetadataSpecifier(String prefix, int index) {
        this.spec = (String)Preconditions.checkNotNull((Object)prefix) + ":" + index;
    }

    private MetadataSpecifier(String prefix, StreamSpecifier spec) {
        this.spec = (String)Preconditions.checkNotNull((Object)prefix) + ":" + ((StreamSpecifier)Preconditions.checkNotNull((Object)spec)).spec();
    }

    public String spec() {
        return this.spec;
    }

    public static String checkValidKey(String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"key must not be empty");
        Preconditions.checkArgument((boolean)key.matches("\\w+"), (Object)"key must only contain letters, numbers or _");
        return key;
    }

    public static MetadataSpecifier global() {
        return new MetadataSpecifier("g");
    }

    public static MetadataSpecifier chapter(int index) {
        return new MetadataSpecifier("c", index);
    }

    public static MetadataSpecifier program(int index) {
        return new MetadataSpecifier("p", index);
    }

    public static MetadataSpecifier stream(int index) {
        return new MetadataSpecifier("s", StreamSpecifier.stream(index));
    }

    public static MetadataSpecifier stream(StreamSpecifierType type) {
        return new MetadataSpecifier("s", StreamSpecifier.stream(type));
    }

    public static MetadataSpecifier stream(StreamSpecifierType stream_type, int stream_index) {
        return new MetadataSpecifier("s", StreamSpecifier.stream(stream_type, stream_index));
    }

    public static MetadataSpecifier stream(StreamSpecifier spec) {
        Preconditions.checkNotNull((Object)spec);
        return new MetadataSpecifier("s", spec);
    }
}

