/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.builder;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import net.bramp.ffmpeg.Preconditions;

public class FFprobeBuilder {
    private boolean showFormat = true;
    private boolean showStreams = true;
    private boolean showChapters = true;
    private boolean showFrames = false;
    private boolean showPackets = false;
    private String userAgent;
    private String input;
    private final List<String> extraArgs = new ArrayList<String>();

    public FFprobeBuilder setShowFormat(boolean showFormat) {
        this.showFormat = showFormat;
        return this;
    }

    public FFprobeBuilder setShowStreams(boolean showStreams) {
        this.showStreams = showStreams;
        return this;
    }

    public FFprobeBuilder setShowChapters(boolean showChapters) {
        this.showChapters = showChapters;
        return this;
    }

    public FFprobeBuilder setShowFrames(boolean showFrames) {
        this.showFrames = showFrames;
        return this;
    }

    public FFprobeBuilder setShowPackets(boolean showPackets) {
        this.showPackets = showPackets;
        return this;
    }

    public FFprobeBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public FFprobeBuilder setInput(String filename) {
        com.google.common.base.Preconditions.checkNotNull((Object)filename);
        this.input = filename;
        return this;
    }

    public FFprobeBuilder addExtraArgs(String ... values) {
        com.google.common.base.Preconditions.checkArgument((values != null ? 1 : 0) != 0, (Object)"extraArgs can not be null");
        com.google.common.base.Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"one or more values must be supplied");
        Preconditions.checkNotEmpty(values[0], "first extra arg may not be empty");
        for (String value : values) {
            this.extraArgs.add((String)com.google.common.base.Preconditions.checkNotNull((Object)value));
        }
        return this;
    }

    @CheckReturnValue
    public List<String> build() {
        ImmutableList.Builder args = new ImmutableList.Builder();
        com.google.common.base.Preconditions.checkNotNull((Object)this.input, (Object)"Input must be specified");
        args.add((Object[])new String[]{"-v", "quiet"}).add((Object[])new String[]{"-print_format", "json"}).add((Object)"-show_error");
        if (this.userAgent != null) {
            args.add((Object[])new String[]{"-user_agent", this.userAgent});
        }
        args.addAll(this.extraArgs);
        if (this.showFormat) {
            args.add((Object)"-show_format");
        }
        if (this.showStreams) {
            args.add((Object)"-show_streams");
        }
        if (this.showChapters) {
            args.add((Object)"-show_chapters");
        }
        if (this.showPackets) {
            args.add((Object)"-show_packets");
        }
        if (this.showFrames) {
            args.add((Object)"-show_frames");
        }
        args.add((Object)this.input);
        return args.build();
    }
}

