/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.builder;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.InlineMe;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import net.bramp.ffmpeg.Preconditions;
import net.bramp.ffmpeg.builder.AbstractFFmpegStreamBuilder;
import net.bramp.ffmpeg.builder.FFmpegBuilder;
import net.bramp.ffmpeg.options.AudioEncodingOptions;
import net.bramp.ffmpeg.options.EncodingOptions;
import net.bramp.ffmpeg.options.MainEncodingOptions;
import net.bramp.ffmpeg.options.VideoEncodingOptions;
import net.bramp.ffmpeg.probe.FFmpegProbeResult;

public class FFmpegOutputBuilder
extends AbstractFFmpegStreamBuilder<FFmpegOutputBuilder> {
    static final Pattern trailingZero = Pattern.compile("\\.0*$");
    @Deprecated
    public Double constantRateFactor;
    @Deprecated
    public String audio_sample_format;
    @Deprecated
    public long audio_bit_rate;
    @Deprecated
    public Double audio_quality;
    @Deprecated
    public String audio_bit_stream_filter;
    @Deprecated
    public String audio_filter;
    @Deprecated
    public long video_bit_rate;
    @Deprecated
    public Double video_quality;
    @Deprecated
    public String video_preset;
    @Deprecated
    public String video_filter;
    @Deprecated
    public String video_bit_stream_filter;

    public FFmpegOutputBuilder() {
    }

    protected FFmpegOutputBuilder(FFmpegBuilder parent, String filename) {
        super(parent, filename);
    }

    protected FFmpegOutputBuilder(FFmpegBuilder parent, URI uri) {
        super(parent, uri);
    }

    public FFmpegOutputBuilder setConstantRateFactor(double factor) {
        com.google.common.base.Preconditions.checkArgument((factor >= 0.0 ? 1 : 0) != 0, (Object)"constant rate factor must be greater or equal to zero");
        this.constantRateFactor = factor;
        return this;
    }

    public FFmpegOutputBuilder setVideoBitRate(long bit_rate) {
        com.google.common.base.Preconditions.checkArgument((bit_rate > 0L ? 1 : 0) != 0, (Object)"bit rate must be positive");
        this.video_enabled = true;
        this.video_bit_rate = bit_rate;
        return this;
    }

    public FFmpegOutputBuilder setVideoQuality(double quality) {
        com.google.common.base.Preconditions.checkArgument((quality > 0.0 ? 1 : 0) != 0, (Object)"quality must be positive");
        this.video_enabled = true;
        this.video_quality = quality;
        return this;
    }

    public FFmpegOutputBuilder setVideoBitStreamFilter(String filter) {
        this.video_bit_stream_filter = Preconditions.checkNotEmpty(filter, "filter must not be empty");
        return this;
    }

    public FFmpegOutputBuilder setVideoPreset(String preset) {
        this.video_enabled = true;
        this.video_preset = Preconditions.checkNotEmpty(preset, "video preset must not be empty");
        return this;
    }

    public FFmpegOutputBuilder setVideoFilter(String filter) {
        this.video_enabled = true;
        this.video_filter = Preconditions.checkNotEmpty(filter, "filter must not be empty");
        return this;
    }

    @Deprecated
    @InlineMe(replacement="this.setAudioSampleFormat(bit_depth)")
    public final FFmpegOutputBuilder setAudioBitDepth(String bit_depth) {
        return this.setAudioSampleFormat(bit_depth);
    }

    public FFmpegOutputBuilder setAudioSampleFormat(String sample_format) {
        this.audio_enabled = true;
        this.audio_sample_format = Preconditions.checkNotEmpty(sample_format, "sample format must not be empty");
        return this;
    }

    public FFmpegOutputBuilder setAudioBitRate(long bit_rate) {
        com.google.common.base.Preconditions.checkArgument((bit_rate > 0L ? 1 : 0) != 0, (Object)"bit rate must be positive");
        this.audio_enabled = true;
        this.audio_bit_rate = bit_rate;
        return this;
    }

    public FFmpegOutputBuilder setAudioQuality(double quality) {
        com.google.common.base.Preconditions.checkArgument((quality > 0.0 ? 1 : 0) != 0, (Object)"quality must be positive");
        this.audio_enabled = true;
        this.audio_quality = quality;
        return this;
    }

    public FFmpegOutputBuilder setAudioBitStreamFilter(String filter) {
        this.audio_enabled = true;
        this.audio_bit_stream_filter = Preconditions.checkNotEmpty(filter, "filter must not be empty");
        return this;
    }

    public FFmpegOutputBuilder setAudioFilter(String filter) {
        this.audio_enabled = true;
        this.audio_filter = Preconditions.checkNotEmpty(filter, "filter must not be empty");
        return this;
    }

    @Override
    @CheckReturnValue
    public EncodingOptions buildOptions() {
        return new EncodingOptions(new MainEncodingOptions(this.format, this.startOffset, this.duration), new AudioEncodingOptions(this.audio_enabled, this.audio_codec, this.audio_channels, this.audio_sample_rate, this.audio_sample_format, this.audio_bit_rate, this.audio_quality), new VideoEncodingOptions(this.video_enabled, this.video_codec, this.video_frame_rate, this.video_width, this.video_height, this.video_bit_rate, this.video_frames, this.video_filter, this.video_preset));
    }

    @Override
    @CheckReturnValue
    protected List<String> build(int pass) {
        com.google.common.base.Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"Can not build without parent being set");
        return this.build(this.parent, pass);
    }

    @Override
    @CheckReturnValue
    protected List<String> build(FFmpegBuilder parent, int pass) {
        if (pass > 0) {
            com.google.common.base.Preconditions.checkArgument((this.targetSize != 0L || this.video_bit_rate != 0L ? 1 : 0) != 0, (Object)"Target size, or video bitrate must be specified when using two-pass");
        }
        if (this.targetSize > 0L) {
            com.google.common.base.Preconditions.checkState((parent.inputs.size() == 1 ? 1 : 0) != 0, (Object)"Target size does not support multiple inputs");
            com.google.common.base.Preconditions.checkArgument((this.constantRateFactor == null ? 1 : 0) != 0, (Object)"Target size can not be used with constantRateFactor");
            String firstInput = parent.inputs.iterator().next();
            FFmpegProbeResult input = parent.inputProbes.get(firstInput);
            com.google.common.base.Preconditions.checkState((input != null ? 1 : 0) != 0, (Object)"Target size must be used with setInput(FFmpegProbeResult)");
            double durationInSeconds = input.format.duration;
            long totalBitRate = (long)Math.floor((double)(this.targetSize * 8L) / durationInSeconds) - this.pass_padding_bitrate;
            if (this.video_enabled && this.video_bit_rate == 0L) {
                long audioBitRate = this.audio_enabled ? this.audio_bit_rate : 0L;
                this.video_bit_rate = totalBitRate - audioBitRate;
            } else if (this.audio_enabled && this.audio_bit_rate == 0L) {
                this.audio_bit_rate = totalBitRate;
            }
        }
        return super.build(parent, pass);
    }

    protected static String formatDecimalInteger(double d) {
        return trailingZero.matcher(String.valueOf(d)).replaceAll("");
    }

    @Override
    protected void addGlobalFlags(FFmpegBuilder parent, ImmutableList.Builder<String> args) {
        super.addGlobalFlags(parent, args);
        if (this.constantRateFactor != null) {
            args.add((Object[])new String[]{"-crf", FFmpegOutputBuilder.formatDecimalInteger(this.constantRateFactor)});
        }
    }

    @Override
    protected void addVideoFlags(FFmpegBuilder parent, ImmutableList.Builder<String> args) {
        super.addVideoFlags(parent, args);
        if (this.video_bit_rate > 0L && this.video_quality != null) {
            throw new IllegalStateException("Only one of video_bit_rate and video_quality can be set");
        }
        if (this.video_bit_rate > 0L) {
            args.add((Object[])new String[]{"-b:v", String.valueOf(this.video_bit_rate)});
        }
        if (this.video_quality != null) {
            args.add((Object[])new String[]{"-qscale:v", FFmpegOutputBuilder.formatDecimalInteger(this.video_quality)});
        }
        if (!Strings.isNullOrEmpty((String)this.video_preset)) {
            args.add((Object[])new String[]{"-vpre", this.video_preset});
        }
        if (!Strings.isNullOrEmpty((String)this.video_filter)) {
            com.google.common.base.Preconditions.checkState((parent.inputs.size() == 1 ? 1 : 0) != 0, (Object)"Video filter only works with one input, instead use setComplexVideoFilter(..)");
            args.add((Object[])new String[]{"-vf", this.video_filter});
        }
        if (!Strings.isNullOrEmpty((String)this.video_bit_stream_filter)) {
            args.add((Object[])new String[]{"-bsf:v", this.video_bit_stream_filter});
        }
    }

    @Override
    protected void addAudioFlags(ImmutableList.Builder<String> args) {
        super.addAudioFlags(args);
        if (!Strings.isNullOrEmpty((String)this.audio_sample_format)) {
            args.add((Object[])new String[]{"-sample_fmt", this.audio_sample_format});
        }
        if (this.audio_bit_rate > 0L && this.audio_quality != null && this.throwWarnings) {
            throw new IllegalStateException("Only one of audio_bit_rate and audio_quality can be set");
        }
        if (this.audio_bit_rate > 0L) {
            args.add((Object[])new String[]{"-b:a", String.valueOf(this.audio_bit_rate)});
        }
        if (this.audio_quality != null) {
            args.add((Object[])new String[]{"-qscale:a", FFmpegOutputBuilder.formatDecimalInteger(this.audio_quality)});
        }
        if (!Strings.isNullOrEmpty((String)this.audio_bit_stream_filter)) {
            args.add((Object[])new String[]{"-bsf:a", this.audio_bit_stream_filter});
        }
        if (!Strings.isNullOrEmpty((String)this.audio_filter)) {
            args.add((Object[])new String[]{"-af", this.audio_filter});
        }
    }

    @Override
    @CheckReturnValue
    protected FFmpegOutputBuilder getThis() {
        return this;
    }

    public Double getConstantRateFactor() {
        return this.constantRateFactor;
    }

    public String getAudioSampleFormat() {
        return this.audio_sample_format;
    }

    public long getAudioBitRate() {
        return this.audio_bit_rate;
    }

    public Double getAudioQuality() {
        return this.audio_quality;
    }

    public String getAudioBitStreamFilter() {
        return this.audio_bit_stream_filter;
    }

    public String getAudioFilter() {
        return this.audio_filter;
    }

    public long getVideoBitRate() {
        return this.video_bit_rate;
    }

    public Double getVideoQuality() {
        return this.video_quality;
    }

    public String getVideoPreset() {
        return this.video_preset;
    }

    public String getVideoFilter() {
        return this.video_filter;
    }

    public String getVideoBitStreamFilter() {
        return this.video_bit_stream_filter;
    }
}

