/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;

public final class Preconditions {
    private static final List<String> rtps = ImmutableList.of((Object)"rtsp", (Object)"rtp", (Object)"rtmp");
    private static final List<String> udpTcp = ImmutableList.of((Object)"udp", (Object)"tcp");

    Preconditions() {
        throw new AssertionError((Object)"No instances for you!");
    }

    public static String checkNotEmpty(String arg, @Nullable Object errorMessage) {
        boolean empty = Strings.isNullOrEmpty((String)arg) || CharMatcher.whitespace().matchesAllOf((CharSequence)arg);
        com.google.common.base.Preconditions.checkArgument((!empty ? 1 : 0) != 0, (Object)errorMessage);
        return arg;
    }

    public static URI checkValidStream(URI uri) throws IllegalArgumentException {
        String scheme = ((URI)com.google.common.base.Preconditions.checkNotNull((Object)uri)).getScheme();
        if (rtps.contains(scheme = Ascii.toLowerCase((String)((String)com.google.common.base.Preconditions.checkNotNull((Object)scheme, (Object)"URI is missing a scheme"))))) {
            return uri;
        }
        if (udpTcp.contains(scheme)) {
            if (uri.getPort() == -1) {
                throw new IllegalArgumentException("must set port when using udp or tcp scheme");
            }
            return uri;
        }
        throw new IllegalArgumentException("not a valid output URL, must use rtp/tcp/udp scheme");
    }
}

