/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg;

import com.google.common.base.Preconditions;
import java.io.IOException;
import net.bramp.ffmpeg.FFmpeg;
import net.bramp.ffmpeg.FFprobe;
import net.bramp.ffmpeg.builder.FFmpegBuilder;
import net.bramp.ffmpeg.job.FFmpegJob;
import net.bramp.ffmpeg.job.SinglePassFFmpegJob;
import net.bramp.ffmpeg.job.TwoPassFFmpegJob;
import net.bramp.ffmpeg.progress.ProgressListener;

public class FFmpegExecutor {
    final FFmpeg ffmpeg;
    final FFprobe ffprobe;

    public FFmpegExecutor() throws IOException {
        this(new FFmpeg(), new FFprobe());
    }

    public FFmpegExecutor(FFmpeg ffmpeg) throws IOException {
        this(ffmpeg, new FFprobe());
    }

    public FFmpegExecutor(FFmpeg ffmpeg, FFprobe ffprobe) {
        this.ffmpeg = (FFmpeg)Preconditions.checkNotNull((Object)ffmpeg);
        this.ffprobe = (FFprobe)Preconditions.checkNotNull((Object)ffprobe);
    }

    public FFmpegJob createJob(FFmpegBuilder builder) {
        return new SinglePassFFmpegJob(this.ffmpeg, builder);
    }

    public FFmpegJob createJob(FFmpegBuilder builder, ProgressListener listener) {
        return new SinglePassFFmpegJob(this.ffmpeg, builder, listener);
    }

    public FFmpegJob createTwoPassJob(FFmpegBuilder builder) {
        return new TwoPassFFmpegJob(this.ffmpeg, builder);
    }

    public FFmpegJob createTwoPassJob(FFmpegBuilder builder, ProgressListener listener) {
        return new TwoPassFFmpegJob(this.ffmpeg, builder, listener);
    }
}

